﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief クロックを即座に操作する機能の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include "pcv_Types.h"

namespace nn { namespace pcv {

//-----------------------------------------------------------------------------
//! @name PCV ライブラリの即応機能の API
//! @{

/**
 * @brief       指定したモジュールのクロックレートを変更します。
 *
 * @param[in]   moduleId 制御対象モジュール
 * @param[in]   clockRateHz 設定するクロックレート
 *
 * @return      処理の結果を返します。
 *
 * @retval      ResultSuccess 成功しました。
 *
 * @pre         @ref nn::pcv::InitializeForImmediate 関数を実行してライブラリを初期化している必要があります。
 *              対象モジュールがクロックレートの変更に対応している必要があります。
 *              @a clockRateHz は対象モジュールに @ref nn::pcv::GetPossibleClockRates を実行した際に得られる @ref nn::pcv::ClockRatesListType に
 *              応じた値になっている必要があります。@ref nn::pcv::ClockRatesListType_Discrete の場合 @ref nn::pcv::SetClockRateImmediately で
 *              正確な値を引数に取らせなければなりません。@ref nn::pcv::ClockRatesListType_Range の場合 @ref nn::pcv::SetClockRateImmediately で
 *              正確な値を引数に取らせる必要はありません。
 *
 * @post        モジュールがクロックレート変更に対応しており、
 *              clockRateHz に適切なクロックレートが指定された場合、
 *              指定されたクロックレートに変更されます。
 *
 * @details     モジュールの @ref nn::pcv::ClockRatesListType が @ref nn::pcv::ClockRatesListType_Range の場合、設定されるクロックレートは、
 *              上限クロックレート以下かつ指定クロックレート以上で設定可能な最小のクロックレートとなります。
 *              指定クロックレート以上に設定不可能な場合は、指定クロックレート以下で設定可能な最大のクロックレートとなります。
 */

Result SetClockRateImmediately(Module moduleId, ClockHz clockRateHz) NN_NOEXCEPT;

//! @}
//-----------------------------------------------------------------------------

}} // namespace nn::pcv
