﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/pctl/pctl_TypesSettings.h>

namespace nn { namespace pctl {

/**
 * @brief ペアレンタルコントロール設定によって制限がかかる機能の種類を示します。
 *
 * @details
 * 本定数は組み合わせで利用されます。@n
 * 暗証番号の設定によって自動的に制限がかかるもの(ネットワーク設定の変更など)の種類は
 * 本定数には含まれません。
 */
enum Feature
{
    Feature_None                      = 0,      //!< なし
    Feature_LaunchApplicationByRating = 0x0001, //!< レーティングによる起動制限
    Feature_SnsPost                   = 0x0002, //!< SNS投稿利用
    Feature_FreeCommunication         = 0x0004, //!< 他の人との自由なコミュニケーション機能
    Feature_StereoVision              = 0x0008  //!< 立体視機能
};

}}
