﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/pctl/pctl_TypesSettings.h>
#include <nn/pctl/pctl_TypesSystemReadOnly.h>

namespace nn { namespace pctl {

/**
 * @brief タイトル別の「他の人との自由なコミュニケーション」に関する利用制限の設定値を表します。
 */
struct FreeCommunicationApplicationInfo
{
    nn::ncm::ApplicationId applicationId;   //!< アプリケーションID
    bool isRestricted;                 //!< 制限値(true なら制限を実施)
};

/**
 * @brief タイトル別の制限対象外設定値を表します。
 */
struct ExemptApplicationInfo
{
    nn::ncm::ApplicationId applicationId;   //!< アプリケーションID
    bool isExempted;                        //!< 制限対象外値(true なら制限対象外)
};

/**
 * @brief 制限レベルで設定される制限値(プリセット値)を表します。
 * @details
 * 詳細は @ref RestrictionSettings をご覧ください。
 * (なお、本構造体は引き続き利用することができます。)
 */
typedef RestrictionSettings SafetyLevelSettings;

}}
