﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/nsd/nsd_Types.h>
#include <nn/ovln/format/ovln_PctlMessage.h>
#include <nn/pctl/pctl_TypesWatcher.h>
#include <nn/pctl/detail/service/common/pctl_SystemInfoTypes.h>
#include <nn/pctl/detail/service/system/pctl_Settings.h>
#include <nn/pctl/detail/service/watcher/pctl_ServerResource.h>
#include <nn/settings/system/settings_Region.h>
#include <nn/settings/system/settings_SerialNumber.h>
#include <nn/time/time_LocationName.h>
#include <nn/time/time_SteadyClockTimePoint.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher {

static const size_t MaxDeviceOwnerCount = 5; // 当面は1人、サイズは大きくはないので少し余裕を取っておく
static const size_t MaxDeviceAuthenticationTokenSize = 2048; // 終端のNULL文字を含まない

struct AuthenticationTokenData
{
    char authToken[MaxDeviceAuthenticationTokenSize + 1];
    NN_PADDING3;
    int64_t tokenExpiresAt;      // 取得したタイミングから失効するまでの時間(秒)
    nn::time::SteadyClockTimePoint tokenRetrieved;  // 取得したタイミングの SteadyClockTimePoint
};

namespace old
{
    // ver. 1.0.0 時点でのConfigデータ
    struct ConfigVer1
    {
        bool isPairingActive;
        uint8_t _reserved1[7];
        nn::nsd::EnvironmentIdentifier environment;
        ServerDeviceId deviceId;
        AuthenticationTokenData token;
        EtagInfo etagForSettings;
        uint8_t _reserved2[40];
    };
}

// true/falseで表すことができる状態の値
enum StatusFlags : uint8_t
{
    StatusFlags_NeedsNotifyUnlinked = 1 << 0  // (一度連携して)通信処理によって連携が解除された旨の通知が必要
};

// オーバーレイ通知が必要な情報の種類(OR で指定)
enum NotifyNecessaryFlags : uint8_t
{
    NotifyNecessaryFlags_None                = 0,
    NotifyNecessaryFlags_SettingChanged      = 1 << 0,
    NotifyNecessaryFlags_Unlinked            = 1 << 1,
    NotifyNecessaryFlags_AlarmSettingChanged = 1 << 2
};

struct Config
{
    uint8_t isPairingActive;
    uint8_t statusFlags;
    uint8_t notifyNecessaryFlags;
    nn::ovln::format::PctlUnlinkReasonFlag unlinkReasonFlags;
    nn::ovln::format::PctlSettingTypeFlagSet changedTypeFlags;
    nn::nsd::EnvironmentIdentifier environment;
    ServerDeviceId deviceId;
    AuthenticationTokenData token;
    EtagInfo etagForSettings;
    // @deprecated no longer used
    nn::time::PosixTime _lastPdmEventTime;
    uint32_t lastPdmAppEventOffset;
    uint32_t lastPdmAccountEventOffset;
    nn::ovln::format::PctlAlarmSettingFlag alarmSettingFlags;
    uint8_t _reserved2[23];
};
NN_STATIC_ASSERT(sizeof(Config) == sizeof(old::ConfigVer1));
NN_STATIC_ASSERT(offsetof(Config, environment) == offsetof(old::ConfigVer1, environment));

struct DeviceStatus
{
    char language[8]; // 8文字までで収まるはず
    nn::settings::system::RegionCode regionCode;
    nn::settings::system::SerialNumber serialNumber;
    uint32_t systemVersion;
    char systemVersionText[common::MaxSystemVersionStringLength];
};

}}}}}
