﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/npns/npns_Types.h>
#include <nn/pctl/detail/service/common/pctl_AsyncContext.h>
#include <nn/pctl/detail/service/common/pctl_Cancelable.h>
#include <nn/pctl/detail/service/watcher/pctl_WatcherData.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher {

////////////////////////////////////////////////////////////////////////////////

//! @brief NPNS用のトークン(NT)を作成します。
class CreateNotificationToken
{
public:
    static nn::Result Execute(nn::npns::NotificationToken& outToken, common::Cancelable* pCancelable) NN_NOEXCEPT;
};

////////////////////////////////////////////////////////////////////////////////

class CreateNotificationTokenExecutor : public common::AsyncContext
{
public:
    explicit CreateNotificationTokenExecutor(common::Cancelable* pCancelable) NN_NOEXCEPT :
        m_pCancelable(pCancelable)
    {
    }

    virtual void CloseContext() NN_NOEXCEPT NN_OVERRIDE
    {
        delete this;
    }

    virtual nn::Result Execute(common::NetworkBuffer& bufferInfo) NN_NOEXCEPT NN_OVERRIDE;
    virtual void Cancel() NN_NOEXCEPT NN_OVERRIDE;
    virtual bool IsCancelTriggered() const NN_NOEXCEPT NN_OVERRIDE
    {
        return m_pCancelable->IsCanceled();
    }

private:

    common::Cancelable* m_pCancelable;
    nn::npns::NotificationToken m_Token;
};

////////////////////////////////////////////////////////////////////////////////

}}}}}
