﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/npns/npns_Types.h>
#include <nn/pctl/detail/service/common/pctl_Cancelable.h>
#include <nn/pctl/detail/service/common/pctl_NetworkBuffer.h>
#include <nn/pctl/detail/service/watcher/pctl_ServerResource.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher {

////////////////////////////////////////////////////////////////////////////////

class NotificationDataReceiver
{
public:
    void ProcessReceiveNotificationData(common::NetworkBuffer& bufferInfo, common::Cancelable& cancelable) NN_NOEXCEPT;

private:
    void ParseNotificationData(common::NetworkBuffer& bufferInfo, common::Cancelable& cancelable, const char* data, size_t dataSize) NN_NOEXCEPT;

    void OnEventSettingChanged() NN_NOEXCEPT;
    void OnEventUnlinked() NN_NOEXCEPT;
    void OnEventOnlineCheck() NN_NOEXCEPT;
    void OnEventUpdateAlarmSettingState(AlarmSettingState alarmSettingState) NN_NOEXCEPT;

    nn::npns::NotificationData m_NotificationData; //!< ProcessReceiveNpnsNotifications でのみ利用(サイズが大きいのでここに宣言)
};

////////////////////////////////////////////////////////////////////////////////

}}}}}
