﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/npns/npns_Types.h>
#include <nn/pctl/pctl_TypesWatcher.h>
#include <nn/pctl/detail/service/common/pctl_AsyncContext.h>
#include <nn/pctl/detail/service/common/pctl_Cancelable.h>
#include <nn/pctl/detail/service/watcher/pctl_RetrieveSettings.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace watcher {

class IntermittentContextBase
{
protected:
    IntermittentContextBase() NN_NOEXCEPT;
public:
    virtual ~IntermittentContextBase() NN_NOEXCEPT;
};

template <class TContextBase, class... TArgs>
class IntermittentContext : public TContextBase,
    public IntermittentContextBase
{
public:
    explicit IntermittentContext(TArgs... args) NN_NOEXCEPT :
        TContextBase(args...)
    {
    }
    virtual ~IntermittentContext() NN_NOEXCEPT
    {
    }
};

// @brief 間欠起動時のバックグラウンド処理を行います。
class IntermittentOperation : public common::AsyncContext
{
private:
    IntermittentOperation() NN_NOEXCEPT; // disallow to use

protected:
    IntermittentOperation(ServerDeviceId deviceId, common::Cancelable* pCancelable) NN_NOEXCEPT
        : m_RetrieveParam()
    {
        m_RetrieveParam.deviceId = deviceId;
        m_RetrieveParam.pCancelable = pCancelable;
    }

public:
    static nn::Result CreateInstance(IntermittentOperation** ppOutInstance, ServerDeviceId deviceId, common::Cancelable* pCancelable) NN_NOEXCEPT;

public:
    virtual ~IntermittentOperation() NN_NOEXCEPT;

    virtual void CloseContext() NN_NOEXCEPT NN_OVERRIDE
    {
        delete this;
    }

    virtual nn::Result Execute(common::NetworkBuffer& bufferInfo) NN_NOEXCEPT NN_OVERRIDE;
    virtual void Cancel() NN_NOEXCEPT NN_OVERRIDE;
    virtual bool IsCancelTriggered() const NN_NOEXCEPT NN_OVERRIDE
    {
        return m_RetrieveParam.pCancelable->IsCanceled();
    }

    static nn::Result NotifyTaskStarting() NN_NOEXCEPT;
    static void NotifyTaskFinished() NN_NOEXCEPT;
    static bool IsInHalfAwake() NN_NOEXCEPT;
    static void ScheduleTask() NN_NOEXCEPT;
    static bool IsSchedulingNecessary() NN_NOEXCEPT;
    static void SetSchedulingNecessary(bool value) NN_NOEXCEPT;

private:
    nn::Result ProcessRetrieveSettings() NN_NOEXCEPT;
    nn::Result ProcessUploadDeviceEvents() NN_NOEXCEPT;

private:
    RetrieveSettingsExecutor::RetrieveSettingsParamBuffer m_RetrieveParam;
    nn::npns::NotificationToken m_NotificationTokenBuffer;
};

}}}}}
