﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_Optional.h>
#include <nn/usb/pd/usb_PdCradle.h>
#include <nn/omm/srv/omm_Common.private.h>

namespace nn { namespace omm { namespace srv {

    class CradleLedController
    {
    public:
        ~CradleLedController() NN_NOEXCEPT;
        void Initialize(const usb::pd::CradleSession& session, ConsoleStyle consoleStyle) NN_NOEXCEPT;

        void On() NN_NOEXCEPT;
        void Off() NN_NOEXCEPT;

    private:
        util::optional<usb::pd::CradleSession> m_Session;
        ConsoleStyle m_ConsoleStyle;
    };
}}}
