﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_SystemEvent.h>

namespace nn { namespace omm {
    void Initialize() NN_NOEXCEPT;
    void Finalize() NN_NOEXCEPT;

    enum class OperationMode : Bit8
    {
        Handheld,
        Console
    };

    OperationMode GetOperationMode() NN_NOEXCEPT;

    enum class CradleStatus : Bit8
    {
        None,
        NotEnoughPower,
        Mountable
    };

    CradleStatus GetCradleStatus() NN_NOEXCEPT;

    Result GetCradleFwVersion(uint32_t* pOutPdcH, uint32_t* pOutPdcA, uint32_t* pOutMcu, uint32_t* pOutDp2Hdmi) NN_NOEXCEPT;

    void GetOperationModeChangeEvent(os::SystemEvent* outValue) NN_NOEXCEPT;

    void EnableAudioVisual() NN_NOEXCEPT;

    void DisableAudioVisual() NN_NOEXCEPT;

    void EnterSleepAndWait(os::SystemEvent* pEvent) NN_NOEXCEPT;

    void FadeInDisplay() NN_NOEXCEPT;

    void FadeOutDisplay() NN_NOEXCEPT;

    void NotifyCecSettingsChanged() NN_NOEXCEPT;

    enum TvPowerStateMatchingMode
    {
        TvPowerStateMatchingMode_Default  = 0,  //!< 本体設定に従う
        TvPowerStateMatchingMode_Disabled = 1,  //!< テレビ電源連動を無効にする
    };

    inline bool IsValidTvPowerStateMatchingMode(int mode) NN_NOEXCEPT
    {
        return mode == TvPowerStateMatchingMode_Default ||
               mode == TvPowerStateMatchingMode_Disabled;
    }

    void SetApplicationCecSettingsAndNotifyChanged(TvPowerStateMatchingMode mode) NN_NOEXCEPT;

    enum class OperationModePolicy : Bit8
    {
        Auto,
        Handheld,
        Console
    };

    Result SetOperationModePolicy(OperationModePolicy policy) NN_NOEXCEPT;

    void GetDefaultDisplayResolution(int32_t* pWidth, int32_t* pHeight) NN_NOEXCEPT;

    void GetDefaultDisplayResolutionChangeEvent(os::SystemEvent* outValue) NN_NOEXCEPT;

    void UpdateDefaultDisplayResolution() NN_NOEXCEPT;

    bool ShouldSleepOnBoot() NN_NOEXCEPT;

    void NotifyHdcpApplicationExecutionStarted() NN_NOEXCEPT;

    void NotifyHdcpApplicationExecutionFinished() NN_NOEXCEPT;

    void NotifyHdcpApplicationDrawingStarted() NN_NOEXCEPT;

    void NotifyHdcpApplicationDrawingFinished() NN_NOEXCEPT;

    void GetHdcpAuthenticationFailedEvent(os::SystemEvent* outValue) NN_NOEXCEPT;

    bool GetHdcpAuthenticationFailedEmulationEnabled() NN_NOEXCEPT;

    Result SetHdcpAuthenticationFailedEmulation(bool enable) NN_NOEXCEPT;

    enum class HdcpState : Bit8
    {
        Unauthenticated,
        ProcessingForeground,
        ProcessingBackground,
        AuthenticationFailed,
        Authenticated
    };

    HdcpState GetHdcpState() NN_NOEXCEPT;

    void GetHdcpStateChangeEvent(os::SystemEvent* outValue) NN_NOEXCEPT;

    void ShowCardUpdateProcessing() NN_NOEXCEPT;
}}
