﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <array>
#include <nn/os.h>
#include <nn/nn_Common.h>

namespace nn { namespace olsc { namespace srv { namespace util {

template<int StackSize>
struct ThreadResource
{
    ThreadResource(const char* name, int priority) NN_NOEXCEPT
        : name(name), priority(priority)
    {}
    const char* name;
    int priority;
    NN_OS_ALIGNAS_THREAD_STACK std::array<char, StackSize> stack;
};


}}}} // nn::olsc::srv::util
