﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_SaveDataTransferForCloudBackUp.h>
#include <nn/nn_Common.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace olsc { namespace srv { namespace util {

class SaveDataAccessLockManager
{
public:
    void Enable(ApplicationId appId) NN_NOEXCEPT;
    void Update(ApplicationId appId, const ApplicationId targets[], int targetCount) NN_NOEXCEPT;
    void Disable(ApplicationId appId) NN_NOEXCEPT;

    void Suppress() NN_NOEXCEPT;
    void Unsuppress() NN_NOEXCEPT;
    int ListLockedApplicationIds(ApplicationId out[], int maxOutCount) const NN_NOEXCEPT;

private:
    static const int MaxAccessLockCount = 32;
    static const int MaxMainApplicationCount = 1;

    class AccessLock
    {
    public:
        NN_IMPLICIT AccessLock(ApplicationId appId) NN_NOEXCEPT
            : m_MainApp(appId)
        {}

        void Append(ApplicationId appId) NN_NOEXCEPT;
        void LockAccess() NN_NOEXCEPT;
        void UnlockAccess() NN_NOEXCEPT;
        ApplicationId GetMainApplicationId() const NN_NOEXCEPT;
        int GetLockedApplicationIdCount() const NN_NOEXCEPT;
        ApplicationId GetLockedApplicationId(int index) const NN_NOEXCEPT;
    private:
        ApplicationId m_MainApp;
        std::array<std::pair<ApplicationId, std::unique_ptr<fs::SaveDataTransferProhibiterForCloudBackUp>>, MaxAccessLockCount> m_AccessLockInfos {};
        int m_AccessLockCount = 0;
    };

    mutable os::SdkRecursiveMutex m_Lock;
    std::array<nn::util::optional<AccessLock>, MaxMainApplicationCount> m_AccessLocks;
    bool m_IsSuppressed = false;

    AccessLock* FindAccessLock(ApplicationId appId) NN_NOEXCEPT;
};

}}}} // nn::olsc::srv::util
