﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_Event.h>
#include <nn/os/os_TimerEvent.h>

namespace nn { namespace olsc { namespace srv { namespace util {

class ManualClearEvent : public os::Event
{
public:
    ManualClearEvent() : Event(os::EventClearMode_ManualClear)
    {}
};

class ManualClearTimerEvent : public os::TimerEvent
{
public:
    ManualClearTimerEvent() : TimerEvent(os::EventClearMode_ManualClear)
    {}
};

}}}} // nn::olsc::srv::util
