﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace olsc { namespace srv { namespace util {

Result CreateFile(const char* path, size_t fileSize) NN_NOEXCEPT;
Result DeleteFile(const char* path) NN_NOEXCEPT;
Result ReadFile(const char* path, void* out, size_t maxReadSize, int64_t offset) NN_NOEXCEPT;
Result ReadFile(size_t* outReadSize, const char* path, void* out, size_t maxReadSize, int64_t offset) NN_NOEXCEPT;
// 指定したサイズのファイルになる
Result WriteFile(const char* path, const void* data, size_t dataSize) NN_NOEXCEPT;
// 既存のファイルサイズを上限とする
Result ModifyFile(const char* path, const void* data, size_t dataSize, int64_t offset) NN_NOEXCEPT;


}}}} // nn::olsc::srv::util
