﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/olsc/detail/olsc_Log.h>
#include <nn/olsc/srv/util/olsc_Os.h>
#include <nn/util/util_Execution.h>

namespace nn { namespace olsc { namespace srv { namespace util {

class SimpleCancelListener : public nn::util::Cancelable::Listener
{
public:
    virtual void Signal() NN_NOEXCEPT NN_OVERRIDE
    {
        m_CancelEvent.Signal();
    }
    ManualClearEvent& GetEvent() NN_NOEXCEPT
    {
        return m_CancelEvent;
    }
private:
    ManualClearEvent m_CancelEvent;
};

}}}}
