﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <curl/curl.h>
#include <nn/account/account_Api.h>
#include <nn/fs/fs_SaveDataTransferForCloudBackUp.h>
#include <nn/nn_ApplicationId.h>
#include <nn/olsc/srv/olsc_InternalTypes.h>
#include <nn/olsc/srv/olsc_TransferTask.h>
#include <nn/olsc/srv/util/olsc_MountManager.h>
#include <nn/olsc/srv/util/olsc_SaveData.h>
#include <nn/time/time_PosixTime.h>
#include <nn/util/util_Execution.h>

namespace nn { namespace olsc { namespace srv { namespace transfer {
    class TransferHelper
    {
    public:
        using ContextInitializer = std::function<void(size_t dataSize, uint32_t maxPartitionsCount)>;
        using ContextUpdater = std::function<void(size_t transferredSize, size_t offsetNumber)>;

        struct Buffer
        {
            union
            {
                TransferTaskBase::SaveDataInfoListBuffer sdaListBuffer;
                fs::InitialDataForCloudBackUp initialData;
            };
            TransferTaskBase::ComponentFileInfoListBuffer componentFileListBuffer;
            std::array<char, 128 * 1024> ioBuffer;
        };

        static Result StartWholeUpload(
            SaveDataArchiveInfo* outSda,
            const account::Uid& uid,
            const ApplicationId appId,
            const SeriesInfo& seriesInfo,
            const NsaIdToken& nsaIdToken,
            const fs::SaveDataInfo& saveDataInfo,
            CURL* curlHandle,
            void* workBuffer, size_t workBufferSize, nn::util::Cancelable& cancelable) NN_NOEXCEPT;

        static Result ExportSaveData(
            SaveDataArchiveId sdaId,
            std::unique_ptr<fs::ISaveDataDivisionExporter>& exporter,
            std::unique_ptr<fs::ISaveDataChunkIterator>& iter,
            NsaIdToken& nsaIdToken,
            CURL* curlHandle,
            const ContextUpdater& contextUpdater,
            const account::Uid& uid,
            void* workBuffer, size_t workBufferSize, nn::util::Cancelable& cancelable) NN_NOEXCEPT;

        static Result FinishWholeUpload(
            SaveDataArchiveId sdaId,
            std::unique_ptr<fs::ISaveDataDivisionExporter>& exporter,
            const NsaIdToken& nsaIdToken,
            CURL* curlHandle,
            void* workBuffer, size_t workBufferSize, nn::util::Cancelable& cancelable) NN_NOEXCEPT;

        static Result GetSuspendedSaveDataArchiveInfo(
            SaveDataArchiveInfo* outSda,
            int* pOutCfCount,
            SaveDataArchiveId sdaId,
            const NsaIdToken& nsaIdToken,
            CURL* curlHandle,
            void* workBuffer, size_t workBufferSize, nn::util::Cancelable& cancelable) NN_NOEXCEPT;

        // DL API
        static Result Download(
            const account::Uid& uid,
            const SaveDataArchiveInfo& sda,
            const NsaIdToken& nsaIdToken,
            CURL* curlHandle,
            const ContextInitializer& contextInitializer, const ContextUpdater& contextUpdater,
            void* workBuffer, size_t workBufferSize, nn::util::Cancelable& cancelable) NN_NOEXCEPT;

    private:
        static Result ImportSaveDataCore(
            const NsaIdToken& nsaIdToken,
            CURL* curlHandle,
            fs::ISaveDataDivisionImporter& importer,
            TransferTaskBase::ComponentFileInfoListBuffer& cfList,
            size_t listCount,
            const ContextUpdater& contextUpdater,
            void* workBuffer,
            size_t workBufferSize,
            nn::util::Cancelable& cancelable) NN_NOEXCEPT;

    };

}}}} // namespace nn::olsc::srv
