﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      olsc モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_OLSC_TRACE(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_OLSC_TRACE_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_OLSC_TRACE_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_OLSC_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_OLSC_INFO(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_OLSC_INFO_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_OLSC_INFO_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_OLSC_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_OLSC_WARN(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_OLSC_WARN_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_OLSC_WARN_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_OLSC_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_OLSC_ERROR(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_OLSC_ERROR_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_OLSC_ERROR_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_OLSC_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_OLSC_FATAL(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_OLSC_FATAL_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_OLSC_FATAL_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_OLSC_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(olsc, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_OLSC_VTRACE(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Trace, 0, format, args)
#define NN_DETAIL_OLSC_VTRACE_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Trace, 1, format, args)
#define NN_DETAIL_OLSC_VTRACE_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Trace, 2, format, args)
#define NN_DETAIL_OLSC_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Trace, 3, format, args)

#define NN_DETAIL_OLSC_VINFO(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Info, 0, format, args)
#define NN_DETAIL_OLSC_VINFO_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Info, 1, format, args)
#define NN_DETAIL_OLSC_VINFO_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Info, 2, format, args)
#define NN_DETAIL_OLSC_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Info, 3, format, args)

#define NN_DETAIL_OLSC_VWARN(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Warn, 0, format, args)
#define NN_DETAIL_OLSC_VWARN_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Warn, 1, format, args)
#define NN_DETAIL_OLSC_VWARN_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Warn, 2, format, args)
#define NN_DETAIL_OLSC_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Warn, 3, format, args)

#define NN_DETAIL_OLSC_VERROR(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Error, 0, format, args)
#define NN_DETAIL_OLSC_VERROR_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Error, 1, format, args)
#define NN_DETAIL_OLSC_VERROR_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Error, 2, format, args)
#define NN_DETAIL_OLSC_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Error, 3, format, args)

#define NN_DETAIL_OLSC_VFATAL(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Fatal, 0, format, args)
#define NN_DETAIL_OLSC_VFATAL_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Fatal, 1, format, args)
#define NN_DETAIL_OLSC_VFATAL_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Fatal, 2, format, args)
#define NN_DETAIL_OLSC_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(olsc, Fatal, 3, format, args)

#define NN_DETAIL_OLSC_PUT_TRACE(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Trace, 0, text, length)
#define NN_DETAIL_OLSC_PUT_TRACE_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Trace, 1, text, length)
#define NN_DETAIL_OLSC_PUT_TRACE_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Trace, 2, text, length)
#define NN_DETAIL_OLSC_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Trace, 3, text, length)

#define NN_DETAIL_OLSC_PUT_INFO(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Info, 0, text, length)
#define NN_DETAIL_OLSC_PUT_INFO_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Info, 1, text, length)
#define NN_DETAIL_OLSC_PUT_INFO_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Info, 2, text, length)
#define NN_DETAIL_OLSC_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Info, 3, text, length)

#define NN_DETAIL_OLSC_PUT_WARN(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Warn, 0, text, length)
#define NN_DETAIL_OLSC_PUT_WARN_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Warn, 1, text, length)
#define NN_DETAIL_OLSC_PUT_WARN_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Warn, 2, text, length)
#define NN_DETAIL_OLSC_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Warn, 3, text, length)

#define NN_DETAIL_OLSC_PUT_ERROR(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Error, 0, text, length)
#define NN_DETAIL_OLSC_PUT_ERROR_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Error, 1, text, length)
#define NN_DETAIL_OLSC_PUT_ERROR_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Error, 2, text, length)
#define NN_DETAIL_OLSC_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Error, 3, text, length)

#define NN_DETAIL_OLSC_PUT_FATAL(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Fatal, 0, text, length)
#define NN_DETAIL_OLSC_PUT_FATAL_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Fatal, 1, text, length)
#define NN_DETAIL_OLSC_PUT_FATAL_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Fatal, 2, text, length)
#define NN_DETAIL_OLSC_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(olsc, Fatal, 3, text, length)
