﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief 性能モードと性能の定義。
 */

namespace nn { namespace oe {

/**
 * @brief   性能モードを表す列挙型です。
 *
 * @details ひとつもしくは幾つかの性能を選択可能なプラットフォームの内部状態を性能モードと呼称します。@n
 *          現在 Generic で指定可能な性能モードはありません。
 */
enum PerformanceMode
{
    PerformanceMode_Invalid = -1, //!< 無効な性能モードです。
};

/**
 * @brief   選択可能な性能を表す型です。
 *
 * @details 現在 Generic で使用可能な性能はありません。
 */
typedef int PerformanceConfiguration;

const PerformanceConfiguration PerformanceConfiguration_Invalid = 0x00000000; //!< 無効な設定です。

}} // namespace nn::oe
