﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   無操作状態の制御に関する API の宣言
 *
 */

#pragma once

#include <nn/nn_Macro.h>

namespace nn { namespace oe {

//--------------------------------------------------------------------------

//! @name   無操作状態の制御に関する API
//! @{

//--------------------------------------------------------------------------
/**
 * @brief   マルチメディアコンテンツ再生区間の開始をシステムに通知します。
 *
 * @details
 *  マルチメディアコンテンツの再生を行なう前に本 API を呼んで下さい。
 *  @n
 *  本関数を呼び出された回数は内部でカウントされています。本関数を呼び出した回数と同じ回数だけ
 *  @ref nn::oe::EndMediaPlaybackSection() が呼び出されたとき、初めて再生区間終了と扱われます。@n
 *
 */
void BeginMediaPlaybackSection() NN_NOEXCEPT;


//--------------------------------------------------------------------------
/**
 * @brief   マルチメディアコンテンツ再生区間の終了をシステムに通知します。
 *
 * @details
 *  マルチメディアコンテンツの再生を終了した後に本 API を呼んで下さい。
 *  @n
 *  本関数を呼び出された回数は内部でカウントされています。 @ref nn::oe::BeginMediaPlaybackSection() を
 *  呼び出した回数と同じ回数だけ本関数が呼び出されたとき、初めて再生区間終了と扱われます。 @n
 *
 */
void EndMediaPlaybackSection() NN_NOEXCEPT;


//! @}

//-----------------------------------------------------------------------------

}} // namespace nn::oe

