﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   LCD バックライト関連機能に関する API の宣言
 *
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/oe/oe_NotificationMessage.h>

namespace nn { namespace oe {

/**
 * @brief   LCD バックライトが点灯したことを示すメッセージ通知です。
 *
 * @details
 *  nn::oe::SwitchLcdBacklightOff() によって LCD バックライトが消灯した後に、
 *  システムによって自動的に LCD バックライトが点灯させることがあった時に、
 *  自プログラムに通知されるメッセージです。
 *
 *  このメッセージ通知を受けた段階で既に LCD バックライトは点灯しているため、
 *  明示的に nn::oe::SwitchLcdBacklightOn() を呼ぶ必要はありません。
 *
 * @note
 *  - この定義は暫定です。将来的に仕様を変更する可能性があります。
 *
 */
const Message MessageLcdBacklightSwitchedOn = 75;

}}  // namespace nn::oe


namespace nn { namespace oe {

//--------------------------------------------------------------------------

//! @name   LCD バックライト関連機能
//! @{

/**
    @brief  LCD バックライトを消灯します。

    @details
     LCD バックライトを消灯します。

     この効果はアプリケーションがインフォーカス状態の間のみ有効で、
     一度でもこれ以外のフォーカス状態に遷移した場合には、
     LCD バックライトはシステムによって自動的に点灯し、
     自プログラムに nn::oe::MessageLcdBacklightSwitchedOn メッセージが
     通知されます。

    @note
     - この API は暫定です。将来的に仕様を変更する可能性があります。

*/
void SwitchLcdBacklightOff() NN_NOEXCEPT;

/**
    @brief  LCD バックライトを点灯します。

    @details
     LCD バックライトを点灯します。
     詳細は nn::oe::SwitchLcdBacklightOff() を参照して下さい。

    @note
     - この API は暫定です。将来的に仕様を変更する可能性があります。

*/
void SwitchLcdBacklightOn() NN_NOEXCEPT;


//! @}

//-----------------------------------------------------------------------------

}} // namespace nn::oe

