﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ntc/detail/service/ntc_IEnsureNetworkClockAvailabilityService.sfdl.h>
#include <nn/ntc/detail/service/ntc_IStaticService.sfdl.h>
#include <nn/ntc/detail/service/ntc_StaticService.h>
#include <nn/ntc/detail/service/ntc_AutonomicEnsureNetworkClockAvailabilityThread.h>

#include <nn/sf/sf_HipcSimpleAllInOneServerManager.h>
#include <nn/sf/sf_ObjectFactory.h>

namespace nn { namespace ntc { namespace detail { namespace service {

const size_t SessionCountMax = 16; // TORIAEZU

class HipcServerManager : public ::nn::sf::HipcSimpleAllInOneServerManager<SessionCountMax * 2, 1>
{
    NN_DISALLOW_COPY(HipcServerManager);
    NN_DISALLOW_MOVE(HipcServerManager);

public:
    explicit HipcServerManager(detail::service::AutonomicEnsureNetworkClockAvailabilityThread* pAutonomicEnsureNetworkClockAvailabilityThread) NN_NOEXCEPT:
        m_StaticService(pAutonomicEnsureNetworkClockAvailabilityThread),
        m_pAutonomicEnsureNetworkClockAvailabilityThread(pAutonomicEnsureNetworkClockAvailabilityThread)
    {}

    void StartThread() NN_NOEXCEPT;
    void StopThread() NN_NOEXCEPT;

    void DispatchFunctionImpl() NN_NOEXCEPT;

private:
    nn::sf::UnmanagedServiceObject<IStaticService, StaticService> m_StaticService;
    detail::service::AutonomicEnsureNetworkClockAvailabilityThread* m_pAutonomicEnsureNetworkClockAvailabilityThread;
};

}}}} // nn::ntc::detail::service
