﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ns/detail/ns_IApplicationManagerInterface.sfdl.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace ns { namespace srv {

    class ApplicationManagerInterfaceServer;

    class ServiceGetterInterfaceServer
    {
    public:
        enum Capability
        {
            ContentManagement           =   1 << 0,
            DownloadTask                =   1 << 1,
            DocumentAccess              =   1 << 2,
            ApplicationManager          =   1 << 3,
            AccountProxyForCreation     =   1 << 4,
            FactoryReset                =   1 << 5,
            ApplicationVersion          =   1 << 6,
            ECommerce                   =   1 << 7,
            ReadOnlyApplicationRecord   =   1 << 8,
            ReadOnlyApplicationControlData      =   1 << 9,
            DynamicRights               =   1 << 10,
        };

        ServiceGetterInterfaceServer(ApplicationManagerInterfaceServer* impl, Bit32 capability) NN_NOEXCEPT;
        ~ServiceGetterInterfaceServer() NN_NOEXCEPT {}

        nn::Result GetDownloadTaskInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IDownloadTaskInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetContentManagementInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IContentManagementInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetDocumentInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IDocumentInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetApplicationManagerInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IApplicationManagerInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetAccountProxyInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAccountProxyInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetFactoryResetInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IFactoryResetInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetApplicationVersionInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IApplicationVersionInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetECommerceInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IECommerceInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetReadOnlyApplicationRecordInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IReadOnlyApplicationRecordInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetReadOnlyApplicationControlDataInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IReadOnlyApplicationControlDataInterface>> outValue) NN_NOEXCEPT;
        nn::Result GetDynamicRightsInterface(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IDynamicRightsInterface>> outValue) NN_NOEXCEPT;

    private:
        ApplicationManagerInterfaceServer* m_Impl;
        Bit32 m_Capability;
    };

}}}
