﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ns/srv/ns_DataStore.h>
#include <nn/ns/srv/ns_IntegratedContentManager.h>
#include <nn/ns/srv/ns_RequestServer.h>
#include <nn/ns/ns_PseudoDeviceIdApi.h>

namespace nn { namespace ns { namespace srv {

    class PseudoDeviceIdManager
    {
    public:
        Result Initialize() NN_NOEXCEPT;
        Result GetSystemSeed(SystemSeedForPseudoDeviceId* pOutSeed) NN_NOEXCEPT;
        Result ResetSystemSeed() NN_NOEXCEPT;

    private:
        SystemSeedForPseudoDeviceId m_SystemSeed;
        os::Mutex m_Mutex{false};
    };

}}}
