﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_SaveDataTypes.h>
#include <nn/ns/srv/ns_RequestServer.h>

namespace nn { namespace ns { namespace srv {
    class FactoryResetManager
    {
    public:
        FactoryResetManager() NN_NOEXCEPT : m_RequestServer(){}

        void Initialize(RequestServer* requestServer) NN_NOEXCEPT
        {
            m_RequestServer = requestServer;
        }
        void InitializeForMaintenanceMode() NN_NOEXCEPT{}
        Result ResetToFactorySettings() NN_NOEXCEPT;
        Result ResetToFactorySettingsWithoutUserSaveData() NN_NOEXCEPT;
        Result ResetToFactorySettingsForRefurbishment() NN_NOEXCEPT;

    private:
        void StopRequestServerPermanently() NN_NOEXCEPT
        {
            if (m_RequestServer)
            {
                m_Stopper = m_RequestServer->Stop();
            }
        }
        Result DeleteAllImages() NN_NOEXCEPT;
        Result DeleteAllDownloadTask() NN_NOEXCEPT;
        Result DeleteAllBuildInUserContents() NN_NOEXCEPT;
        Result DeleteAllSaveDataAtomic(uint32_t keepFlags, bool deleteUser) NN_NOEXCEPT;

        static const int MaxSaveDataIdCountForAtomicReset = 8192;
        fs::SaveDataId m_SaveDataIdBuffer[MaxSaveDataIdCountForAtomicReset];

        RequestServer* m_RequestServer;
        RequestServer::ManagedStop m_Stopper;
    };
}}}
