﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>

namespace nn { namespace ns { namespace srv {
    class ExFatDriverManager
    {
    public:
        ExFatDriverManager() NN_NOEXCEPT : m_IsInitialized() {}
        ~ExFatDriverManager() NN_NOEXCEPT;
        Result Initialize() NN_NOEXCEPT;
        Result NotifyDriverRequired() NN_NOEXCEPT;
        Result NotifyDriverDownloaded() NN_NOEXCEPT;
        Result Clear() NN_NOEXCEPT;

        bool IsDriverRequired() NN_NOEXCEPT
        {
            // SIGLO-63312 のため、インストール済みなら Required と判定する
            return m_SaveData.isDriverRequired || m_IsExFatInstalled;
        }

        bool IsDriverDownloadedAtLeastOnce() NN_NOEXCEPT
        {
            // SIGLO-63312 のため、インストール済みなら DownloadedAtLeastOnce と判定する
            return m_SaveData.isDriverDownloadedAtLeastOnce || m_IsExFatInstalled;
        }

        static Result IsExFatInstalled(bool* outValue) NN_NOEXCEPT;

    private:
        Result Flush() NN_NOEXCEPT;

        struct SaveData
        {
            bool isDriverRequired;
            bool isDriverDownloadedAtLeastOnce;
            Bit8 reserved[510];
        };
        NN_STATIC_ASSERT(sizeof(SaveData) == 512);

        bool m_IsInitialized;
        bool m_IsExFatInstalled;
        SaveData m_SaveData;
    };
}}}
