﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>
#include <nn/os/os_Event.h>
#include <nn/os/os_MultipleWaitTypes.h>
#include <nn/os/os_MultipleWait.h>

namespace nn { namespace ns { namespace srv {

    class Event
    {
    public:
        Event() NN_NOEXCEPT
            : m_Event(os::EventClearMode_AutoClear)
        {
            os::InitializeMultiWaitHolder(&m_Holder, m_Event.GetBase());
        }

        os::MultiWaitHolderType* GetWaitHolder() NN_NOEXCEPT
        {
            return &m_Holder;
        }
        void Signal(int cause) NN_NOEXCEPT
        {
            m_Cause = cause;
            m_Event.Signal();
        }
        void Clear() NN_NOEXCEPT
        {
            m_Event.Clear();
        }
        int GetCause() NN_NOEXCEPT
        {
            return m_Cause;
        }

    private:
         os::MultiWaitHolderType    m_Holder;
         os::Event                  m_Event;
         std::atomic<int>           m_Cause;
    };

}}}  // namespace nn::ns::srv

