﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ns/ns_DeviceLinkApi.h>
#include <nn/ns/ns_TicketApi.h>
#include <nn/ns/srv/ns_RequestServer.h>

namespace nn { namespace ns { namespace srv {
    class ECommerceManager
    {
    public:
        explicit ECommerceManager(RequestServer* requestServer) NN_NOEXCEPT : m_RequestServer(requestServer) {};

        Result RequestLinkDevice(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync, const account::Uid& uid) NN_NOEXCEPT;
        Result RequestSyncRights(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;

    private:
        RequestServer* m_RequestServer;
    };
}}}
