﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/nim/nim_NetworkInstallManagerApi.h>
#include <nn/ns/ns_DownloadTaskSystemApi.h>
#include <nn/ns/srv/ns_ApplicationRecordDatabase.h>
#include <nn/ns/srv/ns_DownloadTask.h>
#include <nn/ns/srv/ns_RequestServer.h>
#include <nn/ns/srv/ns_OsUtil.h>
#include <nn/util/util_Uuid.h>

namespace nn { namespace ns { namespace srv {

    class DownloadTaskListManager
    {
    public:
        DownloadTaskListManager() NN_NOEXCEPT : m_Record() {}
        ~DownloadTaskListManager() NN_NOEXCEPT;

        Result Initialize(ApplicationRecordDatabase* record) NN_NOEXCEPT;

        void Finalize() NN_NOEXCEPT;

        Result Push(const void* data, size_t size) NN_NOEXCEPT;
        Result Push(nim::AsyncData* asyncDownloadTask) NN_NOEXCEPT;

        Result Clear() NN_NOEXCEPT;

        int ListDownloadTaskStatus(DownloadTaskStatus outList[], int count) NN_NOEXCEPT;

        Result RequestEnsureDownloadTask(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync, RequestServer::ManagedStop&& stopper) NN_NOEXCEPT;

        Result RequestDownloadTaskListData(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncValue>> outAsync, RequestServer::ManagedStop&& stopper) NN_NOEXCEPT;

    private:
        Result PushImpl(const char* jsonBuffer, size_t jsonBufferSize, char* buffer, size_t bufferSize) NN_NOEXCEPT;

        template<typename InputStreamType>
        Result PushImpl(InputStreamType& inputStreamForCheck, InputStreamType& inputStreamForParse) NN_NOEXCEPT;

        bool Has(util::Uuid uuid) NN_NOEXCEPT;
        void Add(const DownloadTaskStatus& status) NN_NOEXCEPT;
        void MarkCleanupAll() NN_NOEXCEPT;
        void UnmarkCleanup(util::Uuid uuid) NN_NOEXCEPT;
        void Cleanup() NN_NOEXCEPT;

        NonRecursiveMutex m_Mutex;

        Result CreateInstallTask(DownloadTask* task) NN_NOEXCEPT;

        char m_Buffer[256 * 1024];
        ApplicationRecordDatabase* m_Record;
        DownloadTask m_DownloadTask;
        ncm::StorageContentMetaKey m_PushKeyBuffer[DownloadTask::MaxKeyCount];

        static const int MaxTaskStatusCount = 256;
        DownloadTaskStatus m_TaskStatusList[MaxTaskStatusCount];

        Result Load() NN_NOEXCEPT;
        Result Flush() NN_NOEXCEPT;
    };
}}}
