﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/util/util_Uuid.h>

namespace nn { namespace ns { namespace srv {

    struct DownloadTask
    {
        util::Uuid uuid;
        ncm::ApplicationId applicationId;
        Bit32 installConfig;
        int keyCount;

        static const int MaxKeyCount = 2048;
        ncm::ContentMetaKey keyList[MaxKeyCount];
    };

}}}
