﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include <nn/fs/fs_SystemSaveData.h>
#include <nn/kvdb/kvdb_BoundedString.h>
#include <nn/util/util_UuidTypes.h>
#include <nn/ns/srv/ns_MarkFile.h>
#include <nn/ns/srv/ns_SaveDataInfo.h>

namespace nn { namespace ns { namespace srv {
    class DataStore
    {
    public:
        ~DataStore() NN_NOEXCEPT;
        Result Initialize(const SaveDataInfo& info) NN_NOEXCEPT;
        bool DetectsForceShutdown() NN_NOEXCEPT
        {
            return m_DetectsForceShutdown;
        }

        Result PrepareShutdown() NN_NOEXCEPT
        {
            return UnmarkLiving();
        }

    private:
        typedef kvdb::BoundedString<48> Path;
        util::optional<Path> m_MountName;
        bool m_DetectsForceShutdown;

        Path MakeLivingMarkPath() NN_NOEXCEPT;
        Result HasLivingMark(bool* outValue) NN_NOEXCEPT;
        Result MarkLiving() NN_NOEXCEPT;
        Result UnmarkLiving() NN_NOEXCEPT;
    };
}}}
