﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <nn/fs/fs_IEventNotifier.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ns/srv/ns_BlackListReader.h>

namespace nn { namespace ns { namespace srv {

    class BlackListManager
    {
        NN_DISALLOW_COPY(BlackListManager);

    public:
        BlackListManager() NN_NOEXCEPT;
        Result Initialize() NN_NOEXCEPT;

        bool IsApplicationOnBlackList(ncm::ApplicationId id, uint32_t version) NN_NOEXCEPT;

    private:
        bool m_IsCached;
        mutable std::unique_ptr<fs::IEventNotifier> m_Notifier;
        mutable os::SystemEventType m_UpdateEvent;
        mutable os::ReaderWriterLock m_CacheLock;
        BlackListData m_Cache;

        bool IsCached() const NN_NOEXCEPT;
        void ReadBlackList() NN_NOEXCEPT;
        bool IsRefusedForDebug(ncm::ApplicationId id, uint32_t version) const NN_NOEXCEPT;
        bool IsRefusedByBlackList(ncm::ApplicationId id, uint32_t version) const NN_NOEXCEPT;
    };

}}} // ~namespace nn::ns::srv
