﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/os/os_Mutex.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ns/ns_ApplicationViewApi.h>
#include <nn/ns/srv/ns_ApplicationRecordDatabase.h>

namespace nn { namespace ns { namespace srv {

// 数十個のキャッシュ位を想定している
// 数千とかになると、探索を効率化することを考えたい
class ApplicationEntityViewCacheHolder
{
public:
    ApplicationEntityViewCacheHolder() NN_NOEXCEPT : m_CacheMutex(false), m_CacheUsedCounter(1)
    {
        Clear();
    }
    void Initialize(ApplicationRecordDatabase* db) NN_NOEXCEPT
    {
        m_RecordDatabase = db;
    }
    Result LoadEntityViewCache(ApplicationView* outValue, ncm::ApplicationId id) NN_NOEXCEPT;
    void StoreEntityViewCache(ncm::ApplicationId id, int64_t lastUpdated, const ApplicationView& view) NN_NOEXCEPT;

    void Clear() NN_NOEXCEPT
    {
        for (auto& cache : m_Cache)
        {
            cache.applicationId = ncm::ApplicationId::GetInvalidId();
            cache.cacheUsedCounter = 0; // 0 にしておくことで、LLU で使われるようになる
        }
    }
private:
    struct ApplicationEntityViewCache
    {
        ncm::ApplicationId applicationId;
        int64_t lastUpdated;
        int64_t cacheUsedCounter;
        ApplicationView entityView;
    };

    static const int CacheEntryCount = 64;

    os::Mutex m_CacheMutex;
    ApplicationRecordDatabase* m_RecordDatabase {};
    int64_t m_CacheUsedCounter;
    ApplicationEntityViewCache m_Cache[CacheEntryCount];
};

}}}

