﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ns/ns_ApplicationDownloadApi.h>
#include <nn/ns/ns_ApplicationManagerSystemApi.h>
#include <nn/ns/ns_RetailInteractiveDisplayApi.h>
#include <nn/ns/srv/ns_TaskType.h>
#include <nn/ns/srv/ns_ApplicationRecordDatabase.h>
#include <nn/ns/srv/ns_IntegratedContentManager.h>
#include <nn/ns/srv/ns_LockedBufferManager.h>
#include <nn/ns/srv/ns_RequestServer.h>

namespace nn { namespace ns { namespace srv {
    class ApplicationDownloadManager
    {
    public:
        void Initialize(ApplicationRecordDatabase* recordDb, IntegratedContentManager* integrated, RequestServer* requestServer, LockedBufferManager* lockedBufferManager) NN_NOEXCEPT
        {
            m_RecordDb = recordDb;
            m_Integrated = integrated;
            m_LockedBufferManager = lockedBufferManager;
            m_RequestServer = requestServer;
        }

        Result RequestApplicationUpdateInfo(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncValue>> outAsync, ncm::ApplicationId id) NN_NOEXCEPT;
        Result RequestUpdateApplication(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync, ncm::ApplicationId id) NN_NOEXCEPT;
        Result RequestDownloadApplication(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync, ncm::ApplicationId applicationId, ncm::StorageId storageId, bool forceDirectUpdate) NN_NOEXCEPT;
        Result RequestDownloadAddOnContent(sf::Out<sf::NativeHandle> outHandle, sf::Out<sf::SharedPointer<ns::detail::IAsyncResult>> outAsync, ncm::ApplicationId id, sf::InArray<ncm::ContentMetaKey> keyList, ncm::StorageId storageId) NN_NOEXCEPT;
        // TaskType::All を受け付け可能
        Result CancelTask(ncm::ApplicationId id, TaskType taskType) NN_NOEXCEPT;
        // TaskType::All は受け付けない
        Result ResumeTask(ncm::ApplicationId id, TaskType taskType) NN_NOEXCEPT;
        Result GetApplicationLogoData(sf::Out<std::int64_t> outSize, const sf::OutBuffer& outBuffer, ncm::ApplicationId id, const ncm::Path& logoPath) NN_NOEXCEPT;
        // TaskType::All は受け付けない
        Result CalculateTaskRequiredSize(sf::Out<ncm::StorageId> outStorageId, sf::Out<std::int64_t> outValue, ncm::ApplicationId id, TaskType taskType) NN_NOEXCEPT;
        Result ResumeAll() NN_NOEXCEPT;

    private:
        ApplicationRecordDatabase* m_RecordDb;
        IntegratedContentManager* m_Integrated;
        LockedBufferManager* m_LockedBufferManager;
        RequestServer* m_RequestServer;
    };
}}}
