﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_TimeSpan.h>
#include <nn/util/util_Optional.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ns/ns_ApplicationContentMetaApi.h>
#include <nn/ns/srv/ns_ApplicationLaunchManager.h>
#include <nn/ns/srv/ns_ApplicationRecordDatabase.h>
#include <nn/ns/srv/ns_IntegratedContentManager.h>

namespace nn { namespace ns { namespace srv {

Result ListApplicationContentMetaStatusImpl(int* outCount, ns::ApplicationContentMetaStatus outList[], int maxOutCount, ncm::ApplicationId appId, std::int32_t offset, ApplicationRecordDatabase& recordDb, IntegratedContentManager& integrated, bool checkRights) NN_NOEXCEPT;
Result ListAvailableAddOnContentImpl(int* outCount, ns::ApplicationContentMetaStatus outList[], int maxOutCount, ncm::ApplicationId appId, std::int32_t offset, ApplicationRecordDatabase& recordDb, IntegratedContentManager& integrated, ApplicationLaunchManager& launchManager) NN_NOEXCEPT;

Result CheckRecordAndDatabaseImpl(bool *outHasRecord, bool *outInstalled, ncm::ContentMetaKey key, ncm::ApplicationId id, ApplicationRecordDatabase& recordDb, IntegratedContentManager& integrated) NN_NOEXCEPT;

}}}
