﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/sf_ISharedObject.h>

namespace nn { namespace ns {
    namespace detail {
        class IRequestServerStopper;
    }

    class RequestServerStopper
    {
        NN_DISALLOW_COPY(RequestServerStopper);

    public:
        /**
        * @brief コンストラクタです。
        */
        RequestServerStopper() NN_NOEXCEPT;

        explicit RequestServerStopper(sf::SharedPointer<detail::IRequestServerStopper> interface) NN_NOEXCEPT;

        explicit RequestServerStopper(RequestServerStopper&& rvalue) NN_NOEXCEPT;

        RequestServerStopper& operator=(RequestServerStopper&& rvalue) NN_NOEXCEPT;

        void swap(RequestServerStopper& other) NN_NOEXCEPT;

    private:
        sf::SharedPointer<detail::IRequestServerStopper> m_Interface;
    };
}} // ~nn::ns
