﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ns/ns_Async.h>

namespace nn { namespace ns {

    /**
    * @brief    システム内にあるプリインストール情報を削除します。
    *
    * @details  非同期処理をリクエストして、AsyncResult を返します。
    *           処理の結果は AsyncResult から取得してください。
    *           処理が成功するためには、インフラ通信が確立している必要があります。
    *           この関数で同時にリクエストできる非同期処理は最大１つです。
    *           内部でチケット同期が実行されます。
    *
    * @return   処理の結果が返ります。通信エラーなどは下位レイヤの Result が返されます。必要があればエラーコードを表示してください。
    * @retval   ResultOutOfMaxRunningTask                       同時に発行できるリクエスト数が最大に達しています。
    * @retval   ResultInternetRequestNotAccepted                （AsyncResult から返される Result）ネットワーク接続要求が受理されませんでした。
    * @retval   ec::ResultCanceled                              （AsyncResult から返される Result）処理がキャンセルされました。
    * @retval   ec::ResultSystemUpdateRequired                  （AsyncResult から返される Result）処理を行うためには本体更新が必要です。
    * @retval   ec::ResultDeviceAccountNotRegistered            （AsyncResult から返される Result）デバイスアカウント情報が保存されていません。
    */
    Result RequestCleanupAllPreInstalledApplications(AsyncResult* outValue) NN_NOEXCEPT;

    /**
    * @brief    指定したアプリケーションに関連するプリインストール情報を削除します。
    *
    * @details  非同期処理をリクエストして、AsyncResult を返します。
    *           処理の結果は AsyncResult から取得してください。
    *           処理が成功するためには、インフラ通信が確立している必要があります。
    *           この関数で同時にリクエストできる非同期処理は最大１つです。
    *           内部でチケット同期が実行されます。
    *
    * @return   処理の結果が返ります。通信エラーなどは下位レイヤの Result が返されます。必要があればエラーコードを表示してください。
    * @retval   ResultOutOfMaxRunningTask                       同時に発行できるリクエスト数が最大に達しています。
    * @retval   ResultInternetRequestNotAccepted                （AsyncResult から返される Result）ネットワーク接続要求が受理されませんでした。
    * @retval   ec::ResultCanceled                              （AsyncResult から返される Result）処理がキャンセルされました。
    * @retval   ec::ResultSystemUpdateRequired                  （AsyncResult から返される Result）処理を行うためには本体更新が必要です。
    * @retval   ec::ResultDeviceAccountNotRegistered            （AsyncResult から返される Result）デバイスアカウント情報が保存されていません。
    */
    Result RequestCleanupPreInstalledApplication(AsyncResult* outValue, ncm::ApplicationId id) NN_NOEXCEPT;

}}  // namespace nn::ns
