﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace ns {

    /**
    * @brief    ns の API の使用を開始します。
    *
    * @details  この API は 全ての ns の API の使用前に一度以上呼び出す必要があります。
    *           この API 呼出し後はアプリケーションの持つ権限に応じた ns の API が使用可能になります。
    *           この API は複数回呼び出すことができます。呼び出した回数だけ Finalize を呼ぶようにしてください。
    *
    * @attention  この API は nnMain 以前に呼び出すことはできません。
    *
    * @post
    *           - 権限に応じた ns API が使用可能になる。
    */
    void Initialize() NN_NOEXCEPT;

    /**
    * @brief    ns の API の使用を終了します。
    *
    * @details  ns の API の使用を終了する際に呼んでください。
    *
    * @attention  この API は nnMain 以前に呼び出すことはできません。
    *
    * @pre
    *           - Initialize が一度以上呼び出されている。
    *
    * @post
    *           - ns API の使用ができなくなる。
    */
    void Finalize() NN_NOEXCEPT;

}}  // namespace nn::ns
