﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ns/ns_ApplicationCopyIdentifierTypes.h>
#include <nn/ns/ns_ApplicationLaunchInfo.h>

namespace nn { namespace ns {
    /**
    * @brief    ゲームカードに存在する指定されたアプリケーションのアプリケーションコピー識別子を取得します。
    *
    * @details  ゲームカードのアクセスに失敗すると下位の Result が返ります。
    *
    * @return   処理の結果が返ります。
    * @retval   ResultApplicationCopyIdentifierNotFound             指定されたアプリケーションがゲームカードに見つかりません。
    *
    */
    Result GetGameCardApplicationCopyIdentifier(GameCardApplicationCopyIdentifier* outValue, ncm::ApplicationId id) NN_NOEXCEPT;

    /**
    * @brief    インストールされているアプリケーションのアプリケーションコピー識別子を取得します。
    *
    * @details  インストールされているストレージを指定します。インストールされているアプリケーションのアクセスに失敗すると下位の Result が返ります。
    *
    * @return   処理の結果が返ります。
    * @retval   ResultApplicationCopyIdentifierRightsIdNotDescribed アプリケーションに RightsId が記述されていません。Rights が不要なアプリケーションです。
    * @retval   ResultApplicationCopyIdentifierTicketNotFound       アプリケーションコピー識別子に必要なチケットが見つかりません。
    *
    */
    Result GetInstalledApplicationCopyIdentifier(InstalledApplicationCopyIdentifier* outValue, ncm::ApplicationId id, ncm::StorageId storage) NN_NOEXCEPT;
}}
