﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ns/ns_ApplicationLaunchInfo.h>
#include <nn/settings/settings_Language.h>

namespace nn { namespace ns {
    struct ApplicationControlProperty;
    struct ApplicationControlCacheEntryInfo
    {
        ncm::ApplicationId applicationId;
        uint32_t version;
        Bit8 reserved[4];
        settings::LanguageCode language;
        int64_t iconSize;
    };

    int ListApplicationControlCacheEntryInfo(ApplicationControlCacheEntryInfo outList[], int count) NN_NOEXCEPT;

    Result GetApplicationControlProperty(ApplicationControlProperty* outValue, const ApplicationLaunchInfo& info, uint8_t programIndex) NN_NOEXCEPT;

    // TORIAEZU: 暫定的に作っておく
    struct CommonProgramControlProperty
    {
        Bit64 reserved;
    };

    struct IndividualProgramControlProperty
    {
        Bit64 reserved;
    };

    // TORIAEZU: 必要になったら ApplicationControlProperty に移すのがよさそう

    void GetCommonProgramControlProperty(CommonProgramControlProperty* outValue, const ApplicationControlProperty& property) NN_NOEXCEPT;

    void GetIndividualProgramControlProperty(IndividualProgramControlProperty* outValue, const ApplicationControlProperty& property) NN_NOEXCEPT;

}}  // namespace ns
