﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/nn_Result.h>
#include <nn/ns/detail/ns_IAsync.sfdl.h>
#include <nn/ns/ns_SystemDeliveryInfo.h>
#include <nn/ns/ns_SystemUpdateApi.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace ns { namespace detail { // NOLINT(whitespace/braces)

struct EulaDataPath;

class ISystemUpdateControl;

class ISystemUpdateInterface;

struct EulaDataPath
{
    char str[256];
};

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISystemUpdateControl, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISystemUpdateControl)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HasDownloaded, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestCheckLatestUpdate, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadLatestUpdate, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDownloadProgress, (::nn::sf::Out<::nn::ns::SystemUpdateProgress> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ApplyDownloadedUpdate)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestPrepareCardUpdate, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPrepareCardUpdateProgress, (::nn::sf::Out<::nn::ns::SystemUpdateProgress> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HasPreparedCardUpdate, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ApplyCardUpdate)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDownloadedEulaDataSize, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ns::detail::EulaDataPath& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDownloadedEulaData, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::sf::OutBuffer& buffer, const ::nn::ns::detail::EulaDataPath& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetupCardUpdate, (::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPreparedCardUpdateEulaDataSize, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ns::detail::EulaDataPath& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPreparedCardUpdateEulaData, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::sf::OutBuffer& buffer, const ::nn::ns::detail::EulaDataPath& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetupCardUpdateViaSystemUpdater, (::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(HasReceived, (::nn::sf::Out<bool> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestReceiveSystemUpdate, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::ns::SystemDeliveryInfo& info))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetReceiveProgress, (::nn::sf::Out<::nn::ns::SystemUpdateProgress> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ApplyReceivedUpdate)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetReceivedEulaDataSize, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ns::detail::EulaDataPath& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetReceivedEulaData, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::sf::OutBuffer& buffer, const ::nn::ns::detail::EulaDataPath& path))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(SetupToReceiveSystemUpdate)
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISystemUpdateControl)

        ::nn::Result HasDownloaded(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HasDownloaded, (outValue));
        }

        ::nn::Result RequestCheckLatestUpdate(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestCheckLatestUpdate, (outHandle, outAsync));
        }

        ::nn::Result RequestDownloadLatestUpdate(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestDownloadLatestUpdate, (outHandle, outAsync));
        }

        ::nn::Result GetDownloadProgress(::nn::sf::Out<::nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDownloadProgress, (outValue));
        }

        ::nn::Result ApplyDownloadedUpdate() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ApplyDownloadedUpdate);
        }

        ::nn::Result RequestPrepareCardUpdate(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestPrepareCardUpdate, (outHandle, outAsync));
        }

        ::nn::Result GetPrepareCardUpdateProgress(::nn::sf::Out<::nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPrepareCardUpdateProgress, (outValue));
        }

        ::nn::Result HasPreparedCardUpdate(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HasPreparedCardUpdate, (outValue));
        }

        ::nn::Result ApplyCardUpdate() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ApplyCardUpdate);
        }

        ::nn::Result GetDownloadedEulaDataSize(::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDownloadedEulaDataSize, (outValue, path));
        }

        ::nn::Result GetDownloadedEulaData(::nn::sf::Out<::std::uint64_t> outValue, const ::nn::sf::OutBuffer& buffer, const ::nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDownloadedEulaData, (outValue, buffer, path));
        }

        ::nn::Result SetupCardUpdate(::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetupCardUpdate, (::std::move(transferMemoryHandle), transferMemorySize));
        }

        ::nn::Result GetPreparedCardUpdateEulaDataSize(::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPreparedCardUpdateEulaDataSize, (outValue, path));
        }

        ::nn::Result GetPreparedCardUpdateEulaData(::nn::sf::Out<::std::uint64_t> outValue, const ::nn::sf::OutBuffer& buffer, const ::nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPreparedCardUpdateEulaData, (outValue, buffer, path));
        }

        ::nn::Result SetupCardUpdateViaSystemUpdater(::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetupCardUpdateViaSystemUpdater, (::std::move(transferMemoryHandle), transferMemorySize));
        }

        ::nn::Result HasReceived(::nn::sf::Out<bool> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(HasReceived, (outValue));
        }

        ::nn::Result RequestReceiveSystemUpdate(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::ns::SystemDeliveryInfo& info) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestReceiveSystemUpdate, (outHandle, outAsync, ipv4, port, info));
        }

        ::nn::Result GetReceiveProgress(::nn::sf::Out<::nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetReceiveProgress, (outValue));
        }

        ::nn::Result ApplyReceivedUpdate() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ApplyReceivedUpdate);
        }

        ::nn::Result GetReceivedEulaDataSize(::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetReceivedEulaDataSize, (outValue, path));
        }

        ::nn::Result GetReceivedEulaData(::nn::sf::Out<::std::uint64_t> outValue, const ::nn::sf::OutBuffer& buffer, const ::nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetReceivedEulaData, (outValue, buffer, path));
        }

        ::nn::Result SetupToReceiveSystemUpdate() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(SetupToReceiveSystemUpdate);
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISystemUpdateControl
    {
    public:
        nn::Result HasDownloaded(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result RequestCheckLatestUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;
        nn::Result RequestDownloadLatestUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
        nn::Result GetDownloadProgress(nn::sf::Out<nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT;
        nn::Result ApplyDownloadedUpdate() NN_NOEXCEPT;
        nn::Result RequestPrepareCardUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
        nn::Result GetPrepareCardUpdateProgress(nn::sf::Out<nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT;
        nn::Result HasPreparedCardUpdate(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result ApplyCardUpdate() NN_NOEXCEPT;
        nn::Result GetDownloadedEulaDataSize(nn::sf::Out<std::uint64_t> outValue, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT;
        nn::Result GetDownloadedEulaData(nn::sf::Out<std::uint64_t> outValue, const nn::sf::OutBuffer& buffer, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT;
        nn::Result SetupCardUpdate(nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize) NN_NOEXCEPT;
        nn::Result GetPreparedCardUpdateEulaDataSize(nn::sf::Out<std::uint64_t> outValue, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT;
        nn::Result GetPreparedCardUpdateEulaData(nn::sf::Out<std::uint64_t> outValue, const nn::sf::OutBuffer& buffer, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT;
        nn::Result SetupCardUpdateViaSystemUpdater(nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize) NN_NOEXCEPT;
        nn::Result HasReceived(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
        nn::Result RequestReceiveSystemUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, std::uint32_t ipv4, std::uint16_t port, const nn::ns::SystemDeliveryInfo& info) NN_NOEXCEPT;
        nn::Result GetReceiveProgress(nn::sf::Out<nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT;
        nn::Result ApplyReceivedUpdate() NN_NOEXCEPT;
        nn::Result GetReceivedEulaDataSize(nn::sf::Out<std::uint64_t> outValue, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT;
        nn::Result GetReceivedEulaData(nn::sf::Out<std::uint64_t> outValue, const nn::sf::OutBuffer& buffer, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT;
        nn::Result SetupToReceiveSystemUpdate() NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result HasDownloaded(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result RequestCheckLatestUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT;
    nn::Result RequestDownloadLatestUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
    nn::Result GetDownloadProgress(nn::sf::Out<nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT;
    nn::Result ApplyDownloadedUpdate() NN_NOEXCEPT;
    nn::Result RequestPrepareCardUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT;
    nn::Result GetPrepareCardUpdateProgress(nn::sf::Out<nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT;
    nn::Result HasPreparedCardUpdate(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result ApplyCardUpdate() NN_NOEXCEPT;
    nn::Result GetDownloadedEulaDataSize(nn::sf::Out<std::uint64_t> outValue, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT;
    nn::Result GetDownloadedEulaData(nn::sf::Out<std::uint64_t> outValue, const nn::sf::OutBuffer& buffer, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT;
    nn::Result SetupCardUpdate(nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize) NN_NOEXCEPT;
    nn::Result GetPreparedCardUpdateEulaDataSize(nn::sf::Out<std::uint64_t> outValue, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT;
    nn::Result GetPreparedCardUpdateEulaData(nn::sf::Out<std::uint64_t> outValue, const nn::sf::OutBuffer& buffer, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT;
    nn::Result SetupCardUpdateViaSystemUpdater(nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize) NN_NOEXCEPT;
    nn::Result HasReceived(nn::sf::Out<bool> outValue) NN_NOEXCEPT;
    nn::Result RequestReceiveSystemUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, std::uint32_t ipv4, std::uint16_t port, const nn::ns::SystemDeliveryInfo& info) NN_NOEXCEPT;
    nn::Result GetReceiveProgress(nn::sf::Out<nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT;
    nn::Result ApplyReceivedUpdate() NN_NOEXCEPT;
    nn::Result GetReceivedEulaDataSize(nn::sf::Out<std::uint64_t> outValue, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT;
    nn::Result GetReceivedEulaData(nn::sf::Out<std::uint64_t> outValue, const nn::sf::OutBuffer& buffer, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT;
    nn::Result SetupToReceiveSystemUpdate() NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ns::detail::ISystemUpdateControl))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasDownloaded, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HasDownloaded, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestCheckLatestUpdate, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestCheckLatestUpdate, (outHandle, outAsync));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadLatestUpdate, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestDownloadLatestUpdate, (outHandle, outAsync));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDownloadProgress, (::nn::sf::Out<::nn::ns::SystemUpdateProgress> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDownloadProgress, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ApplyDownloadedUpdate)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ApplyDownloadedUpdate);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestPrepareCardUpdate, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestPrepareCardUpdate, (outHandle, outAsync));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPrepareCardUpdateProgress, (::nn::sf::Out<::nn::ns::SystemUpdateProgress> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPrepareCardUpdateProgress, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasPreparedCardUpdate, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HasPreparedCardUpdate, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ApplyCardUpdate)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ApplyCardUpdate);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDownloadedEulaDataSize, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ns::detail::EulaDataPath& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDownloadedEulaDataSize, (outValue, path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDownloadedEulaData, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::sf::OutBuffer& buffer, const ::nn::ns::detail::EulaDataPath& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDownloadedEulaData, (outValue, buffer, path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetupCardUpdate, (::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetupCardUpdate, (::std::move(transferMemoryHandle), transferMemorySize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPreparedCardUpdateEulaDataSize, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ns::detail::EulaDataPath& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPreparedCardUpdateEulaDataSize, (outValue, path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPreparedCardUpdateEulaData, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::sf::OutBuffer& buffer, const ::nn::ns::detail::EulaDataPath& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPreparedCardUpdateEulaData, (outValue, buffer, path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetupCardUpdateViaSystemUpdater, (::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetupCardUpdateViaSystemUpdater, (::std::move(transferMemoryHandle), transferMemorySize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasReceived, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(HasReceived, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestReceiveSystemUpdate, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::ns::SystemDeliveryInfo& info))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestReceiveSystemUpdate, (outHandle, outAsync, ipv4, port, info));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReceiveProgress, (::nn::sf::Out<::nn::ns::SystemUpdateProgress> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetReceiveProgress, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ApplyReceivedUpdate)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ApplyReceivedUpdate);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReceivedEulaDataSize, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ns::detail::EulaDataPath& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetReceivedEulaDataSize, (outValue, path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReceivedEulaData, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::sf::OutBuffer& buffer, const ::nn::ns::detail::EulaDataPath& path))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetReceivedEulaData, (outValue, buffer, path));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(SetupToReceiveSystemUpdate)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(SetupToReceiveSystemUpdate);
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ns::detail::ISystemUpdateControl>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ns::detail::ISystemUpdateControl))

    // nn::Result HasDownloaded(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HasDownloaded)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HasDownloaded)

    // nn::Result RequestCheckLatestUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestCheckLatestUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestCheckLatestUpdate)

    // nn::Result RequestDownloadLatestUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestDownloadLatestUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestDownloadLatestUpdate)

    // nn::Result GetDownloadProgress(nn::sf::Out<nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDownloadProgress)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ns::SystemUpdateProgress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDownloadProgress)

    // nn::Result ApplyDownloadedUpdate() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ApplyDownloadedUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ApplyDownloadedUpdate)

    // nn::Result RequestPrepareCardUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestPrepareCardUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestPrepareCardUpdate)

    // nn::Result GetPrepareCardUpdateProgress(nn::sf::Out<nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPrepareCardUpdateProgress)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ns::SystemUpdateProgress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPrepareCardUpdateProgress)

    // nn::Result HasPreparedCardUpdate(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HasPreparedCardUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HasPreparedCardUpdate)

    // nn::Result ApplyCardUpdate() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ApplyCardUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ApplyCardUpdate)

    // nn::Result GetDownloadedEulaDataSize(nn::sf::Out<std::uint64_t> outValue, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDownloadedEulaDataSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::ns::detail::EulaDataPath&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDownloadedEulaDataSize)

    // nn::Result GetDownloadedEulaData(nn::sf::Out<std::uint64_t> outValue, const nn::sf::OutBuffer& buffer, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDownloadedEulaData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::ns::detail::EulaDataPath&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (path, buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDownloadedEulaData)

    // nn::Result SetupCardUpdate(nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetupCardUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(transferMemoryHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (transferMemoryHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(transferMemorySize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (transferMemorySize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferMemoryHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferMemorySize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetupCardUpdate)

    // nn::Result GetPreparedCardUpdateEulaDataSize(nn::sf::Out<std::uint64_t> outValue, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPreparedCardUpdateEulaDataSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::ns::detail::EulaDataPath&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPreparedCardUpdateEulaDataSize)

    // nn::Result GetPreparedCardUpdateEulaData(nn::sf::Out<std::uint64_t> outValue, const nn::sf::OutBuffer& buffer, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPreparedCardUpdateEulaData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::ns::detail::EulaDataPath&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (path, buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPreparedCardUpdateEulaData)

    // nn::Result SetupCardUpdateViaSystemUpdater(nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetupCardUpdateViaSystemUpdater)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(transferMemoryHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (transferMemoryHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(transferMemorySize, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (transferMemorySize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferMemoryHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(transferMemorySize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetupCardUpdateViaSystemUpdater)

    // nn::Result HasReceived(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(HasReceived)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(HasReceived)

    // nn::Result RequestReceiveSystemUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, std::uint32_t ipv4, std::uint16_t port, const nn::ns::SystemDeliveryInfo& info) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestReceiveSystemUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(info, 0, (const ::nn::ns::SystemDeliveryInfo&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (info))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(port, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ipv4, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (port, ipv4))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ipv4), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(port), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(info)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestReceiveSystemUpdate)

    // nn::Result GetReceiveProgress(nn::sf::Out<nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetReceiveProgress)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ns::SystemUpdateProgress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetReceiveProgress)

    // nn::Result ApplyReceivedUpdate() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ApplyReceivedUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ApplyReceivedUpdate)

    // nn::Result GetReceivedEulaDataSize(nn::sf::Out<std::uint64_t> outValue, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetReceivedEulaDataSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::ns::detail::EulaDataPath&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (path))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetReceivedEulaDataSize)

    // nn::Result GetReceivedEulaData(nn::sf::Out<std::uint64_t> outValue, const nn::sf::OutBuffer& buffer, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetReceivedEulaData)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(path, 0, (const ::nn::ns::detail::EulaDataPath&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(buffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (path, buffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(buffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(path)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetReceivedEulaData)

    // nn::Result SetupToReceiveSystemUpdate() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetupToReceiveSystemUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetupToReceiveSystemUpdate)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::SystemUpdateProgress), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::SystemDeliveryInfo), 256, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ns::detail::ISystemUpdateControl, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ns::detail::ISystemUpdateControl))

    // nn::Result HasDownloaded(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasDownloaded, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HasDownloaded)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HasDownloaded)
    }

    // nn::Result RequestCheckLatestUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncValue>> outAsync) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestCheckLatestUpdate, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>> outAsync))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestCheckLatestUpdate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestCheckLatestUpdate)
    }

    // nn::Result RequestDownloadLatestUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestDownloadLatestUpdate, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestDownloadLatestUpdate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestDownloadLatestUpdate)
    }

    // nn::Result GetDownloadProgress(nn::sf::Out<nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDownloadProgress, (::nn::sf::Out<::nn::ns::SystemUpdateProgress> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDownloadProgress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDownloadProgress)
    }

    // nn::Result ApplyDownloadedUpdate() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ApplyDownloadedUpdate)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ApplyDownloadedUpdate)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ApplyDownloadedUpdate)
    }

    // nn::Result RequestPrepareCardUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestPrepareCardUpdate, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestPrepareCardUpdate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestPrepareCardUpdate)
    }

    // nn::Result GetPrepareCardUpdateProgress(nn::sf::Out<nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPrepareCardUpdateProgress, (::nn::sf::Out<::nn::ns::SystemUpdateProgress> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPrepareCardUpdateProgress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPrepareCardUpdateProgress)
    }

    // nn::Result HasPreparedCardUpdate(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasPreparedCardUpdate, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HasPreparedCardUpdate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HasPreparedCardUpdate)
    }

    // nn::Result ApplyCardUpdate() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ApplyCardUpdate)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ApplyCardUpdate)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ApplyCardUpdate)
    }

    // nn::Result GetDownloadedEulaDataSize(nn::sf::Out<std::uint64_t> outValue, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDownloadedEulaDataSize, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ns::detail::EulaDataPath& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDownloadedEulaDataSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDownloadedEulaDataSize)
    }

    // nn::Result GetDownloadedEulaData(nn::sf::Out<std::uint64_t> outValue, const nn::sf::OutBuffer& buffer, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDownloadedEulaData, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::sf::OutBuffer& buffer, const ::nn::ns::detail::EulaDataPath& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDownloadedEulaData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDownloadedEulaData)
    }

    // nn::Result SetupCardUpdate(nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetupCardUpdate, (::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetupCardUpdate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferMemoryHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferMemorySize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetupCardUpdate)
    }

    // nn::Result GetPreparedCardUpdateEulaDataSize(nn::sf::Out<std::uint64_t> outValue, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPreparedCardUpdateEulaDataSize, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ns::detail::EulaDataPath& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPreparedCardUpdateEulaDataSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPreparedCardUpdateEulaDataSize)
    }

    // nn::Result GetPreparedCardUpdateEulaData(nn::sf::Out<std::uint64_t> outValue, const nn::sf::OutBuffer& buffer, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPreparedCardUpdateEulaData, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::sf::OutBuffer& buffer, const ::nn::ns::detail::EulaDataPath& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPreparedCardUpdateEulaData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPreparedCardUpdateEulaData)
    }

    // nn::Result SetupCardUpdateViaSystemUpdater(nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetupCardUpdateViaSystemUpdater, (::nn::sf::NativeHandle&& transferMemoryHandle, ::std::uint64_t transferMemorySize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetupCardUpdateViaSystemUpdater)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferMemoryHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(transferMemorySize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetupCardUpdateViaSystemUpdater)
    }

    // nn::Result HasReceived(nn::sf::Out<bool> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(HasReceived, (::nn::sf::Out<bool> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(HasReceived)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(HasReceived)
    }

    // nn::Result RequestReceiveSystemUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, std::uint32_t ipv4, std::uint16_t port, const nn::ns::SystemDeliveryInfo& info) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestReceiveSystemUpdate, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::ns::SystemDeliveryInfo& info))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestReceiveSystemUpdate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ipv4)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(port)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(info)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestReceiveSystemUpdate)
    }

    // nn::Result GetReceiveProgress(nn::sf::Out<nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReceiveProgress, (::nn::sf::Out<::nn::ns::SystemUpdateProgress> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetReceiveProgress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetReceiveProgress)
    }

    // nn::Result ApplyReceivedUpdate() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ApplyReceivedUpdate)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ApplyReceivedUpdate)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ApplyReceivedUpdate)
    }

    // nn::Result GetReceivedEulaDataSize(nn::sf::Out<std::uint64_t> outValue, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReceivedEulaDataSize, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::ns::detail::EulaDataPath& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetReceivedEulaDataSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetReceivedEulaDataSize)
    }

    // nn::Result GetReceivedEulaData(nn::sf::Out<std::uint64_t> outValue, const nn::sf::OutBuffer& buffer, const nn::ns::detail::EulaDataPath& path) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetReceivedEulaData, (::nn::sf::Out<::std::uint64_t> outValue, const ::nn::sf::OutBuffer& buffer, const ::nn::ns::detail::EulaDataPath& path))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetReceivedEulaData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(buffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(path)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetReceivedEulaData)
    }

    // nn::Result SetupToReceiveSystemUpdate() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(SetupToReceiveSystemUpdate)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetupToReceiveSystemUpdate)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetupToReceiveSystemUpdate)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ns::detail::ISystemUpdateControl>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ns::detail::ISystemUpdateControl))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HasDownloaded)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HasDownloaded)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestCheckLatestUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncValue>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestCheckLatestUpdate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestDownloadLatestUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestDownloadLatestUpdate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDownloadProgress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDownloadProgress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ApplyDownloadedUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ApplyDownloadedUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestPrepareCardUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestPrepareCardUpdate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPrepareCardUpdateProgress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPrepareCardUpdateProgress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HasPreparedCardUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HasPreparedCardUpdate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ApplyCardUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ApplyCardUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDownloadedEulaDataSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDownloadedEulaDataSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDownloadedEulaData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDownloadedEulaData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetupCardUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(transferMemoryHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetupCardUpdate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(transferMemoryHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(transferMemorySize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPreparedCardUpdateEulaDataSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPreparedCardUpdateEulaDataSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPreparedCardUpdateEulaData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPreparedCardUpdateEulaData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetupCardUpdateViaSystemUpdater)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(transferMemoryHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetupCardUpdateViaSystemUpdater)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(transferMemoryHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(transferMemorySize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(HasReceived)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(HasReceived)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestReceiveSystemUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(info)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestReceiveSystemUpdate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ipv4),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(port),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(info)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetReceiveProgress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetReceiveProgress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ApplyReceivedUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ApplyReceivedUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetReceivedEulaDataSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetReceivedEulaDataSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetReceivedEulaData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(path)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(buffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetReceivedEulaData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(buffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(path)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetupToReceiveSystemUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetupToReceiveSystemUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HasDownloaded)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestCheckLatestUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestDownloadLatestUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDownloadProgress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ApplyDownloadedUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestPrepareCardUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPrepareCardUpdateProgress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HasPreparedCardUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ApplyCardUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDownloadedEulaDataSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDownloadedEulaData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetupCardUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPreparedCardUpdateEulaDataSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPreparedCardUpdateEulaData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetupCardUpdateViaSystemUpdater)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(HasReceived)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestReceiveSystemUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetReceiveProgress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ApplyReceivedUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetReceivedEulaDataSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetReceivedEulaData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetupToReceiveSystemUpdate)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ns::detail::ISystemUpdateControl))

namespace nn { namespace ns { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISystemUpdateInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISystemUpdateInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBackgroundNetworkUpdateState, (::nn::sf::Out<::nn::ns::BackgroundNetworkUpdateState> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenSystemUpdateControl, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::ISystemUpdateControl>> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(NotifyExFatDriverRequired)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ClearExFatDriverStatusForDebug)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(RequestBackgroundNetworkUpdate)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(NotifyBackgroundNetworkUpdate, (const ::nn::ncm::ContentMetaKey& systemUpdateMetaKey))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(NotifyExFatDriverDownloadedForDebug)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemUpdateNotificationEventForContentDelivery, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(NotifySystemUpdateForContentDelivery)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(PrepareShutdown)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DestroySystemUpdateTask)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RequestSendSystemUpdate, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::ns::SystemDeliveryInfo& info))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSendSystemUpdateProgress, (::nn::sf::Out<::nn::ns::SystemUpdateProgress> outValue))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISystemUpdateInterface)

        ::nn::Result GetBackgroundNetworkUpdateState(::nn::sf::Out<::nn::ns::BackgroundNetworkUpdateState> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBackgroundNetworkUpdateState, (outValue));
        }

        ::nn::Result OpenSystemUpdateControl(::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::ISystemUpdateControl>> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenSystemUpdateControl, (outValue));
        }

        ::nn::Result NotifyExFatDriverRequired() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(NotifyExFatDriverRequired);
        }

        ::nn::Result ClearExFatDriverStatusForDebug() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ClearExFatDriverStatusForDebug);
        }

        ::nn::Result RequestBackgroundNetworkUpdate() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(RequestBackgroundNetworkUpdate);
        }

        ::nn::Result NotifyBackgroundNetworkUpdate(const ::nn::ncm::ContentMetaKey& systemUpdateMetaKey) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(NotifyBackgroundNetworkUpdate, (systemUpdateMetaKey));
        }

        ::nn::Result NotifyExFatDriverDownloadedForDebug() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(NotifyExFatDriverDownloadedForDebug);
        }

        ::nn::Result GetSystemUpdateNotificationEventForContentDelivery(::nn::sf::Out<::nn::sf::NativeHandle> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSystemUpdateNotificationEventForContentDelivery, (outValue));
        }

        ::nn::Result NotifySystemUpdateForContentDelivery() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(NotifySystemUpdateForContentDelivery);
        }

        ::nn::Result PrepareShutdown() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(PrepareShutdown);
        }

        ::nn::Result DestroySystemUpdateTask() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DestroySystemUpdateTask);
        }

        ::nn::Result RequestSendSystemUpdate(::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::ns::SystemDeliveryInfo& info) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RequestSendSystemUpdate, (outHandle, outAsync, ipv4, port, info));
        }

        ::nn::Result GetSendSystemUpdateProgress(::nn::sf::Out<::nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSendSystemUpdateProgress, (outValue));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISystemUpdateInterface
    {
    public:
        nn::Result GetBackgroundNetworkUpdateState(nn::sf::Out<nn::ns::BackgroundNetworkUpdateState> outValue) NN_NOEXCEPT;
        nn::Result OpenSystemUpdateControl(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::ISystemUpdateControl>> outValue) NN_NOEXCEPT;
        nn::Result NotifyExFatDriverRequired() NN_NOEXCEPT;
        nn::Result ClearExFatDriverStatusForDebug() NN_NOEXCEPT;
        nn::Result RequestBackgroundNetworkUpdate() NN_NOEXCEPT;
        nn::Result NotifyBackgroundNetworkUpdate(const nn::ncm::ContentMetaKey& systemUpdateMetaKey) NN_NOEXCEPT;
        nn::Result NotifyExFatDriverDownloadedForDebug() NN_NOEXCEPT;
        nn::Result GetSystemUpdateNotificationEventForContentDelivery(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
        nn::Result NotifySystemUpdateForContentDelivery() NN_NOEXCEPT;
        nn::Result PrepareShutdown() NN_NOEXCEPT;
        nn::Result DestroySystemUpdateTask() NN_NOEXCEPT;
        nn::Result RequestSendSystemUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, std::uint32_t ipv4, std::uint16_t port, const nn::ns::SystemDeliveryInfo& info) NN_NOEXCEPT;
        nn::Result GetSendSystemUpdateProgress(nn::sf::Out<nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetBackgroundNetworkUpdateState(nn::sf::Out<nn::ns::BackgroundNetworkUpdateState> outValue) NN_NOEXCEPT;
    nn::Result OpenSystemUpdateControl(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::ISystemUpdateControl>> outValue) NN_NOEXCEPT;
    nn::Result NotifyExFatDriverRequired() NN_NOEXCEPT;
    nn::Result ClearExFatDriverStatusForDebug() NN_NOEXCEPT;
    nn::Result RequestBackgroundNetworkUpdate() NN_NOEXCEPT;
    nn::Result NotifyBackgroundNetworkUpdate(const nn::ncm::ContentMetaKey& systemUpdateMetaKey) NN_NOEXCEPT;
    nn::Result NotifyExFatDriverDownloadedForDebug() NN_NOEXCEPT;
    nn::Result GetSystemUpdateNotificationEventForContentDelivery(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT;
    nn::Result NotifySystemUpdateForContentDelivery() NN_NOEXCEPT;
    nn::Result PrepareShutdown() NN_NOEXCEPT;
    nn::Result DestroySystemUpdateTask() NN_NOEXCEPT;
    nn::Result RequestSendSystemUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, std::uint32_t ipv4, std::uint16_t port, const nn::ns::SystemDeliveryInfo& info) NN_NOEXCEPT;
    nn::Result GetSendSystemUpdateProgress(nn::sf::Out<nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::ns::detail::ISystemUpdateInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBackgroundNetworkUpdateState, (::nn::sf::Out<::nn::ns::BackgroundNetworkUpdateState> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBackgroundNetworkUpdateState, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSystemUpdateControl, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::ISystemUpdateControl>> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenSystemUpdateControl, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(NotifyExFatDriverRequired)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(NotifyExFatDriverRequired);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearExFatDriverStatusForDebug)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ClearExFatDriverStatusForDebug);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestBackgroundNetworkUpdate)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(RequestBackgroundNetworkUpdate);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyBackgroundNetworkUpdate, (const ::nn::ncm::ContentMetaKey& systemUpdateMetaKey))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(NotifyBackgroundNetworkUpdate, (systemUpdateMetaKey));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(NotifyExFatDriverDownloadedForDebug)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(NotifyExFatDriverDownloadedForDebug);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemUpdateNotificationEventForContentDelivery, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSystemUpdateNotificationEventForContentDelivery, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(NotifySystemUpdateForContentDelivery)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(NotifySystemUpdateForContentDelivery);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(PrepareShutdown)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(PrepareShutdown);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DestroySystemUpdateTask)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DestroySystemUpdateTask);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSendSystemUpdate, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::ns::SystemDeliveryInfo& info))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RequestSendSystemUpdate, (outHandle, outAsync, ipv4, port, info));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSendSystemUpdateProgress, (::nn::sf::Out<::nn::ns::SystemUpdateProgress> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSendSystemUpdateProgress, (outValue));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::ns::detail::ISystemUpdateInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::ns::detail::ISystemUpdateInterface))

    // nn::Result GetBackgroundNetworkUpdateState(nn::sf::Out<nn::ns::BackgroundNetworkUpdateState> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBackgroundNetworkUpdateState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ns::BackgroundNetworkUpdateState), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBackgroundNetworkUpdateState)

    // nn::Result OpenSystemUpdateControl(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::ISystemUpdateControl>> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSystemUpdateControl)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSystemUpdateControl)

    // nn::Result NotifyExFatDriverRequired() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifyExFatDriverRequired)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifyExFatDriverRequired)

    // nn::Result ClearExFatDriverStatusForDebug() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearExFatDriverStatusForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearExFatDriverStatusForDebug)

    // nn::Result RequestBackgroundNetworkUpdate() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestBackgroundNetworkUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestBackgroundNetworkUpdate)

    // nn::Result NotifyBackgroundNetworkUpdate(const nn::ncm::ContentMetaKey& systemUpdateMetaKey) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifyBackgroundNetworkUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(systemUpdateMetaKey, (::nn::ncm::ContentMetaKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (systemUpdateMetaKey))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(systemUpdateMetaKey)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifyBackgroundNetworkUpdate)

    // nn::Result NotifyExFatDriverDownloadedForDebug() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifyExFatDriverDownloadedForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifyExFatDriverDownloadedForDebug)

    // nn::Result GetSystemUpdateNotificationEventForContentDelivery(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSystemUpdateNotificationEventForContentDelivery)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outValue, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSystemUpdateNotificationEventForContentDelivery)

    // nn::Result NotifySystemUpdateForContentDelivery() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifySystemUpdateForContentDelivery)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifySystemUpdateForContentDelivery)

    // nn::Result PrepareShutdown() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PrepareShutdown)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PrepareShutdown)

    // nn::Result DestroySystemUpdateTask() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroySystemUpdateTask)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroySystemUpdateTask)

    // nn::Result RequestSendSystemUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, std::uint32_t ipv4, std::uint16_t port, const nn::ns::SystemDeliveryInfo& info) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestSendSystemUpdate)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(info, 0, (const ::nn::ns::SystemDeliveryInfo&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (info))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(port, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ipv4, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (port, ipv4))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ipv4), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(port), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(info)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestSendSystemUpdate)

    // nn::Result GetSendSystemUpdateProgress(nn::sf::Out<nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSendSystemUpdateProgress)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::nn::ns::SystemUpdateProgress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSendSystemUpdateProgress)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::BackgroundNetworkUpdateState), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ContentMetaKey), 16, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::SystemDeliveryInfo), 256, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::SystemUpdateProgress), 16, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::ns::detail::ISystemUpdateInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::ns::detail::ISystemUpdateInterface))

    // nn::Result GetBackgroundNetworkUpdateState(nn::sf::Out<nn::ns::BackgroundNetworkUpdateState> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBackgroundNetworkUpdateState, (::nn::sf::Out<::nn::ns::BackgroundNetworkUpdateState> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBackgroundNetworkUpdateState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBackgroundNetworkUpdateState)
    }

    // nn::Result OpenSystemUpdateControl(nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::ISystemUpdateControl>> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenSystemUpdateControl, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::ISystemUpdateControl>> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSystemUpdateControl)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSystemUpdateControl)
    }

    // nn::Result NotifyExFatDriverRequired() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(NotifyExFatDriverRequired)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifyExFatDriverRequired)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifyExFatDriverRequired)
    }

    // nn::Result ClearExFatDriverStatusForDebug() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearExFatDriverStatusForDebug)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearExFatDriverStatusForDebug)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearExFatDriverStatusForDebug)
    }

    // nn::Result RequestBackgroundNetworkUpdate() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestBackgroundNetworkUpdate)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestBackgroundNetworkUpdate)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestBackgroundNetworkUpdate)
    }

    // nn::Result NotifyBackgroundNetworkUpdate(const nn::ncm::ContentMetaKey& systemUpdateMetaKey) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyBackgroundNetworkUpdate, (const ::nn::ncm::ContentMetaKey& systemUpdateMetaKey))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifyBackgroundNetworkUpdate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(systemUpdateMetaKey)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifyBackgroundNetworkUpdate)
    }

    // nn::Result NotifyExFatDriverDownloadedForDebug() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(NotifyExFatDriverDownloadedForDebug)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifyExFatDriverDownloadedForDebug)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifyExFatDriverDownloadedForDebug)
    }

    // nn::Result GetSystemUpdateNotificationEventForContentDelivery(nn::sf::Out<nn::sf::NativeHandle> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemUpdateNotificationEventForContentDelivery, (::nn::sf::Out<::nn::sf::NativeHandle> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSystemUpdateNotificationEventForContentDelivery)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSystemUpdateNotificationEventForContentDelivery)
    }

    // nn::Result NotifySystemUpdateForContentDelivery() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(NotifySystemUpdateForContentDelivery)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifySystemUpdateForContentDelivery)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifySystemUpdateForContentDelivery)
    }

    // nn::Result PrepareShutdown() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(PrepareShutdown)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PrepareShutdown)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PrepareShutdown)
    }

    // nn::Result DestroySystemUpdateTask() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DestroySystemUpdateTask)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroySystemUpdateTask)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroySystemUpdateTask)
    }

    // nn::Result RequestSendSystemUpdate(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ns::detail::IAsyncResult>> outAsync, std::uint32_t ipv4, std::uint16_t port, const nn::ns::SystemDeliveryInfo& info) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RequestSendSystemUpdate, (::nn::sf::Out<::nn::sf::NativeHandle> outHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>> outAsync, ::std::uint32_t ipv4, ::std::uint16_t port, const ::nn::ns::SystemDeliveryInfo& info))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestSendSystemUpdate)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ipv4)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(port)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(info)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestSendSystemUpdate)
    }

    // nn::Result GetSendSystemUpdateProgress(nn::sf::Out<nn::ns::SystemUpdateProgress> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSendSystemUpdateProgress, (::nn::sf::Out<::nn::ns::SystemUpdateProgress> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSendSystemUpdateProgress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSendSystemUpdateProgress)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::ns::detail::ISystemUpdateInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::ns::detail::ISystemUpdateInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBackgroundNetworkUpdateState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBackgroundNetworkUpdateState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSystemUpdateControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::ISystemUpdateControl>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSystemUpdateControl)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifyExFatDriverRequired)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifyExFatDriverRequired)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearExFatDriverStatusForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearExFatDriverStatusForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestBackgroundNetworkUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestBackgroundNetworkUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifyBackgroundNetworkUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifyBackgroundNetworkUpdate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(systemUpdateMetaKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifyExFatDriverDownloadedForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifyExFatDriverDownloadedForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSystemUpdateNotificationEventForContentDelivery)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outValue)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSystemUpdateNotificationEventForContentDelivery)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifySystemUpdateForContentDelivery)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifySystemUpdateForContentDelivery)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PrepareShutdown)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PrepareShutdown)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroySystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroySystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestSendSystemUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(info)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::ns::detail::IAsyncResult>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestSendSystemUpdate)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ipv4),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(port),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(info)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSendSystemUpdateProgress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSendSystemUpdateProgress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBackgroundNetworkUpdateState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSystemUpdateControl)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifyExFatDriverRequired)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearExFatDriverStatusForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestBackgroundNetworkUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifyBackgroundNetworkUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifyExFatDriverDownloadedForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSystemUpdateNotificationEventForContentDelivery)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifySystemUpdateForContentDelivery)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PrepareShutdown)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroySystemUpdateTask)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestSendSystemUpdate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSendSystemUpdateProgress)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::ns::detail::ISystemUpdateInterface))
