﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace ns { namespace detail {

    enum class ApplicationLanguage :Bit8
    {
        AmericanEnglish = 0,
        BritishEnglish,
        Japanese,
        French,
        German,
        LatinAmericanSpanish,
        Spanish,
        Italian,
        Dutch,
        CanadianFrench,
        Portuguese,
        Russian,
        Korean,
        TraditionalChinese,
        SimplifiedChinese,
        Max
    };

    inline Bit32 ToSupportedLanguageFlag(ApplicationLanguage language) NN_NOEXCEPT
    {
        return 0x1u << static_cast<int>(language);
    }

}}}
