﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/err/err_ErrorContext.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/ncm/ncm_InstallTaskBase.h>
#include <nn/ncm/ncm_ContentMetaDatabase.h>
#include <nn/ncm/ncm_ContentMeta.h>
#include <nn/nim/srv/nim_DeviceContext.h>
#include <nn/nim/srv/nim_HttpConnection.h>

namespace nn { namespace nim { namespace srv {

    class NetworkInstallTaskBase : public ncm::InstallTaskBase
    {
    public:
        virtual void Cancel() NN_NOEXCEPT NN_OVERRIDE;
        virtual void ResetCancel() NN_NOEXCEPT NN_OVERRIDE;
        void SetBuffer(void* buffer, size_t bufferSize) NN_NOEXCEPT
        {
            m_Buffer = static_cast<char*>(buffer);
            m_BufferSize = bufferSize;
        }
        Result InitializeBeforeRun() NN_NOEXCEPT
        {
            return m_Connection.Initialize(m_DeviceContext);
        }
        void FinalizeAfterRun() NN_NOEXCEPT
        {
            m_Connection.GetErrorContext(&m_ErrorContext);
            m_Connection.Finalize();
        }
        void GetErrorContext(err::ErrorContext* outValue) const NN_NOEXCEPT
        {
            *outValue = m_ErrorContext;
        }

    protected:
        Result Initialize(DeviceContext* deviceContext, ncm::StorageId storage, ncm::InstallTaskDataBase* data, bool isSystem, Bit32 config) NN_NOEXCEPT;
        virtual Result GetInstallContentMetaInfo(ncm::InstallContentMetaInfo* outValue, const ncm::ContentMetaKey& key) NN_NOEXCEPT NN_OVERRIDE;

        DeviceContext* GetDeviceContext() NN_NOEXCEPT
        {
            return m_DeviceContext;
        }

        HttpConnection* GetHttpConnection() NN_NOEXCEPT
        {
            return &m_Connection;
        }

    private:
        // TODO: 本来 ncm::InstallTaskBase にあるべき
        virtual int CountInstallContentMetaKey() NN_NOEXCEPT = 0;
        virtual Result GetInstallContentMetaKey(ncm::ContentMetaKey* outValue, int index) NN_NOEXCEPT = 0;

        virtual Result PrepareInstallContentMetaData() NN_NOEXCEPT NN_OVERRIDE;
        virtual Result OnWritePlaceHolder(ncm::InstallContentInfo* data) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result GetLatestVersion(util::optional<uint32_t>* outValue, Bit64 id) NN_NOEXCEPT NN_OVERRIDE;

        Result WritePlaceHolderWithBuffer(ncm::InstallContentInfo* data, const void* buffer, size_t bufferSize) NN_NOEXCEPT;
        Result FlushBuffer(ncm::InstallContentInfo* data) NN_NOEXCEPT;
        size_t FillBuffer(const void* buffer, size_t bufferSize) NN_NOEXCEPT;
        void ClearBuffer() NN_NOEXCEPT;

        HttpConnection m_Connection;
        ncm::InstallTaskDataBase* m_Data{};
        DeviceContext* m_DeviceContext{};
        char* m_Buffer{};
        size_t m_BufferSize{};
        size_t m_BufferFilledSize{};
        bool m_IsSystem{};
        err::ErrorContext m_ErrorContext{};
    };
}}}
