﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include <nn/ssl/ssl_Context.h>

namespace nn { namespace nim { namespace srv {
    class DeviceContext
    {
    public:
        ~DeviceContext() NN_NOEXCEPT;
        Result Initialize() NN_NOEXCEPT;

        ssl::Context* GetSslContext() NN_NOEXCEPT
        {
            return &(*m_SslContext);
        }

        const char* GetPrivateUserAgentHeader() const NN_NOEXCEPT
        {
            return m_PrivateUserAgentHeader;
        }

        const char* GetPublicUserAgentHeader() const NN_NOEXCEPT
        {
            return m_PublicUserAgentHeader;
        }

        Bit64 GetDeviceId() const NN_NOEXCEPT
        {
            return m_DeviceId;
        }

    private:
        util::optional<ssl::Context> m_SslContext;
        char m_PrivateUserAgentHeader[256];
        char m_PublicUserAgentHeader[256];
        Bit64 m_DeviceId;
    };
}}}
