﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_Thread.h>
#include <nn/os/os_Event.h>
#include <nn/os/os_Tick.h>
#include <nn/nim/srv/nim_DeviceContext.h>
#include <nn/nim/srv/nim_HttpConnection.h>
#include <nn/nim/nim_BackgroundDownloadStressTaskInfo.h>
#include <nn/ncm/ncm_ContentStorage.h>

namespace nn { namespace nim { namespace srv {

    class BackgroundDownloadStressTask
    {
    public:
        static const char* DefaultDownloadUrl;

    public:
        BackgroundDownloadStressTask() NN_NOEXCEPT;

        ~BackgroundDownloadStressTask() NN_NOEXCEPT;

        Result Initialize(const char* url, ncm::StorageId storageId, DeviceContext* pDeviceContext) NN_NOEXCEPT;

        void Run() NN_NOEXCEPT;

        void GetInfo(BackgroundDownloadStressTaskInfo* outValue) const NN_NOEXCEPT;

    private:
        Result Execute() NN_NOEXCEPT;

        Result Flush() NN_NOEXCEPT;

        Result WriteToPlaceHolder(const void* buffer, size_t bufferSize) NN_NOEXCEPT;

        Result SetupContentStorage() NN_NOEXCEPT;

        void CleanupContentStorage() NN_NOEXCEPT;

        void Measure(size_t downloadSize) NN_NOEXCEPT;

        size_t FillBuffer(const void* buffer, size_t bufferSize) NN_NOEXCEPT;

        const char* m_Url;
        ncm::PlaceHolderId m_PlaceHolderId;
        ncm::ContentStorage m_ContentStorage;
        ncm::StorageId m_StorageId;
        HttpConnection m_Connection;
        os::ThreadType m_Thread;
        os::Event m_Event;
        os::Tick m_BeginMeasurement;
        Bit8*  m_Buffer;
        size_t m_BufferSize;
        size_t m_BufferFilledSize;
        int64_t m_WriteOffset;
        int64_t m_MeasurementSize;
        double m_Throughput; // KB/s
        Result m_LastResult;
        bool m_IsInitialized;
        BackgroundDownloadStressTaskState m_State;
    };

}}}

