﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_Uuid.h>

namespace nn { namespace nim {

#define NN_NIM_DEFINE_TASK_ID_TYPE(name) \
    struct name \
    { \
        util::Uuid uuid; \
\
        bool IsValid() NN_NOEXCEPT \
        { \
            return uuid != util::InvalidUuid; \
        } \
    }; \
\
    inline bool operator ==(const name& lhs, const name& rhs) NN_NOEXCEPT \
    { \
        return lhs.uuid == rhs.uuid; \
    } \
\
    inline bool operator !=(const name& lhs, const name& rhs) NN_NOEXCEPT \
    { \
        return !(lhs == rhs); \
    }

}}
