﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      nim モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_NIM_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(nim, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_NIM_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nim, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_NIM_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nim, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_NIM_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nim, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_NIM_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(nim, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_NIM_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nim, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_NIM_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nim, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_NIM_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nim, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_NIM_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(nim, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_NIM_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nim, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_NIM_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nim, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_NIM_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(nim, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_NIM_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(nim, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_NIM_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nim, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_NIM_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nim, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_NIM_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nim, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_NIM_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(nim, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_NIM_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nim, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_NIM_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nim, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_NIM_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(nim, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_NIM_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Trace, 0, format, args)
#define NN_DETAIL_NIM_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Trace, 1, format, args)
#define NN_DETAIL_NIM_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Trace, 2, format, args)
#define NN_DETAIL_NIM_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Trace, 3, format, args)

#define NN_DETAIL_NIM_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Info, 0, format, args)
#define NN_DETAIL_NIM_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Info, 1, format, args)
#define NN_DETAIL_NIM_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Info, 2, format, args)
#define NN_DETAIL_NIM_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Info, 3, format, args)

#define NN_DETAIL_NIM_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Warn, 0, format, args)
#define NN_DETAIL_NIM_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Warn, 1, format, args)
#define NN_DETAIL_NIM_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Warn, 2, format, args)
#define NN_DETAIL_NIM_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Warn, 3, format, args)

#define NN_DETAIL_NIM_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Error, 0, format, args)
#define NN_DETAIL_NIM_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Error, 1, format, args)
#define NN_DETAIL_NIM_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Error, 2, format, args)
#define NN_DETAIL_NIM_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Error, 3, format, args)

#define NN_DETAIL_NIM_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Fatal, 0, format, args)
#define NN_DETAIL_NIM_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Fatal, 1, format, args)
#define NN_DETAIL_NIM_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Fatal, 2, format, args)
#define NN_DETAIL_NIM_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(nim, Fatal, 3, format, args)

#define NN_DETAIL_NIM_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(nim, Trace, 0, text, length)
#define NN_DETAIL_NIM_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nim, Trace, 1, text, length)
#define NN_DETAIL_NIM_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nim, Trace, 2, text, length)
#define NN_DETAIL_NIM_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nim, Trace, 3, text, length)

#define NN_DETAIL_NIM_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(nim, Info, 0, text, length)
#define NN_DETAIL_NIM_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nim, Info, 1, text, length)
#define NN_DETAIL_NIM_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nim, Info, 2, text, length)
#define NN_DETAIL_NIM_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nim, Info, 3, text, length)

#define NN_DETAIL_NIM_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(nim, Warn, 0, text, length)
#define NN_DETAIL_NIM_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nim, Warn, 1, text, length)
#define NN_DETAIL_NIM_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nim, Warn, 2, text, length)
#define NN_DETAIL_NIM_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(nim, Warn, 3, text, length)

#define NN_DETAIL_NIM_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(nim, Error, 0, text, length)
#define NN_DETAIL_NIM_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nim, Error, 1, text, length)
#define NN_DETAIL_NIM_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nim, Error, 2, text, length)
#define NN_DETAIL_NIM_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nim, Error, 3, text, length)

#define NN_DETAIL_NIM_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(nim, Fatal, 0, text, length)
#define NN_DETAIL_NIM_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nim, Fatal, 1, text, length)
#define NN_DETAIL_NIM_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nim, Fatal, 2, text, length)
#define NN_DETAIL_NIM_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(nim, Fatal, 3, text, length)
