﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/nifm_Common.h>

namespace nn
{
namespace nifm
{

/**
 * @brief アクセスポイントとの通信の品質を表します。
 */
enum LinkLevel
{
    LinkLevel_0 = 0,   //!< 非常に通信品質が悪い、もしくは通信が成立していない状態を表します。
    LinkLevel_1,       //!< 通信品質が悪い状態を表します。
    LinkLevel_2,       //!< 通信品質があまり良くない状態を表します。
    LinkLevel_3,       //!< 通信品質が良い状態を表します。

    LinkLevel_Count,
};

}
}
