﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/nifm_Common.h>

#include <nn/nifm/nifm_TypesTelemetry.h>

#include <nn/os/os_SystemEvent.h>

namespace nn
{
namespace nifm
{

    //! @name ネットワークテレメトリ（エラーレポート）関連 API
    //! @{

    /**
     * @brief ネットワークテレメトリ情報の更新イベントをバインドします。
     *
     * @param[out] pEventType システムイベント
     * @param[in]  clearMode  イベントのクリアモード
     *
     * @pre
     *   - ライブラリが初期化済み
     *   - pOutEventType != nullptr
     *   - pOutEventType は未初期状態
     *
     * @post
     *   - pOutEventType は初期化状態
     *
     * @details
     *  未初期化の SystemEventType のポインタとクリアモードを渡すことで、
     *  ネットワークテレメトリ情報の更新イベントを受け取るための ReadableHandle がアタッチされて初期化されます。
     */
    void BindTelemetryInfoEvent(nn::os::SystemEventType* pEventType, nn::os::EventClearMode clearMode) NN_NOEXCEPT;

    /**
     * @brief ネットワークテレメトリ情報を取得します。
     *
     * @param[out] pOutTelemetryInfo ネットワークテレメトリ情報
     *
     * @pre
     *   - ライブラリが初期化済み
     *
     * @details
     */
    void GetTelemetoryInfo(TelemetryInfo *pOutTelemetryInfo) NN_NOEXCEPT;

    //! @}

}
}
