﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/nifm_Common.h>

#include <nn/nifm/nifm_TypesInternetConnectionStatus.h>

namespace nn
{
namespace nifm
{
    //! @name 現在のインターネット接続に関する情報取得 API
    //! @{

    /**
     * @brief 現在のインターネット接続に関する情報を取得します
     *
     * @param[out] pOutInternetConnectionStatus   現在のインターネット接続に関する情報
     *
     * @retresult
     *   @handleresult{
     *     nn::ResultSuccess, 処理に成功しました。
     *   }
     * @endretresult
     *
     * @pre
     *   - ライブラリが初期化済み
     *   - pOutInternetConnectionStatus != nullptr
     *
     * @details
     *  現在のインターネット接続に関する情報を取得します。現在、接続中または接続試行中でない場合は失敗します。
     *  現在無線接続の場合はリンクレベルと疎通確認状態が、有線接続の場合は疎通確認状態が取得できます。
     *
     */
    nn::Result GetInternetConnectionStatus(InternetConnectionStatus *pOutInternetConnectionStatus) NN_NOEXCEPT;

    //! @}
}
}
