﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>

#include <nn/nifm/nifm_TypesIpSetting.h>
#include <nn/nifm/nifm_TypesNetworkInterface.h>

#include <nn/tsc/tsc_ConfigContexts.h>
#include <nn/tsc/tsc_ActiveConfigContext.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/util/util_Optional.h>


namespace nn
{
namespace nifm
{
namespace detail
{

class IpSetting;

class IpConfiguration
{
private:
    mutable nn::os::SdkMutex m_Mutex;  // TODO: [TORIAZEU] IPC 受付スレッドからの m_pActiveConfigContext へのアクセスを排他しているのみ

    mutable nn::util::optional<nn::tsc::Ipv4ConfigContext> m_Ipv4ConfigContext;
    mutable nn::util::optional<nn::tsc::ActiveConfigContext> m_ActiveConfigContext;

    mutable nn::util::optional<MacAddress> m_DefaultGatewayMacAddressCache;     // Look up 時にエントリが失効している可能性があるので、一度引いたものは憶えておく。

    NetworkInterfaceType m_NetworkInterfaceType;

public:
    IpConfiguration() NN_NOEXCEPT;
    ~IpConfiguration() NN_NOEXCEPT;

    nn::Result Initialize(const char* pInterfaceName, NetworkInterfaceType networkInterfaceType) NN_NOEXCEPT;

    bool IsInitialized() const NN_NOEXCEPT;

    nn::Result ApplyIpSetting(const IpSetting& ipSetting) NN_NOEXCEPT;

    bool IsActive() const NN_NOEXCEPT;

    nn::Result NotifyInterfaceDown() NN_NOEXCEPT;

    nn::Result GetIpAddress(IpV4Address* pOutIpAddress) const NN_NOEXCEPT;

    nn::Result GetIpConfigInfo(IpAddressSetting* pOutIpAddressSetting, DnsSetting* pDnsSetting) const NN_NOEXCEPT;

    // pSystemEvent は DHCP renew に失敗したときにシグナルするイベントへのポインタ
    // nullptr が返ることもある
    nn::os::SystemEvent* GetSystemEventPointer() NN_NOEXCEPT;

    nn::Result GetInterfaceStatus() NN_NOEXCEPT;

    nn::Result GetDefaultGatewayMacAddress(MacAddress* pOutMacAddress) const NN_NOEXCEPT;
};

}
}
}
