﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/nifm/detail/nifm_Log.h>
#include <nn/nn_SdkAssert.h>

// TODO: 細かい変換
#define NN_DETAIL_NIFM_RETURN_RESULT_IF_WINAPI_FAILED(exp)                  \
    do                                                                      \
    {                                                                       \
        DWORD error_ = exp;                                                 \
        if( error_ != ERROR_SUCCESS )                                       \
        {                                                                   \
            NN_RESULT_THROW(nn::nifm::ResultWindowsApiFailed());            \
        }                                                                   \
    } while( NN_STATIC_CONDITION(false) )

#define NN_DETAIL_NIFM_ASSERT_NOT_MEMORY_OVERLAP(a1, size1, a2, size2)                                \
    NN_SDK_ASSERT((reinterpret_cast<const char*>(a1) + size1) <= reinterpret_cast<const char*>(a2) || \
                  (reinterpret_cast<const char*>(a2) + size2) <= reinterpret_cast<const char*>(a1),   \
                  "%p, %u, %p, %u", a1, size1, a2, size2);
